# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class outer_tag(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/termination-point/eth-svc/supported-vlan-operations/vlan-push/outer-tag. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Indicates the supported VLAN operation capabilities
on the outer VLAN tag.
  """
  __slots__ = ('_path_helper', '_extmethods', '__supported_tag_types','__vlan_range',)

  _yang_name = 'outer-tag'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__supported_tag_types = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 's-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:s-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:s-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}},)), is_leaf=False, yang_name="supported-tag-types", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:eth-tag-type', is_config=True)
    self.__vlan_range = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([1-9][0-9]{0,3}(-[1-9][0-9]{0,3})?(,[1-9][0-9]{0,3}(-[1-9][0-9]{0,3})?)*)'}), is_leaf=True, yang_name="vlan-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:vid-range-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'termination-point', 'eth-svc', 'supported-vlan-operations', 'vlan-push', 'outer-tag']

  def _get_supported_tag_types(self):
    """
    Getter method for supported_tag_types, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_push/outer_tag/supported_tag_types (etht-types:eth-tag-type)

    YANG Description: List of VLAN tag types that can be used to push or swap a
VLAN tag. In case VLAN push/swap is not supported, the list
is empty.
    """
    return self.__supported_tag_types
      
  def _set_supported_tag_types(self, v, load=False):
    """
    Setter method for supported_tag_types, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_push/outer_tag/supported_tag_types (etht-types:eth-tag-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_supported_tag_types is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_supported_tag_types() directly.

    YANG Description: List of VLAN tag types that can be used to push or swap a
VLAN tag. In case VLAN push/swap is not supported, the list
is empty.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 's-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:s-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:s-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}},)), is_leaf=False, yang_name="supported-tag-types", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:eth-tag-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """supported_tag_types must be of a type compatible with etht-types:eth-tag-type""",
          'defined-type': "etht-types:eth-tag-type",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 's-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:s-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:s-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}},)), is_leaf=False, yang_name="supported-tag-types", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:eth-tag-type', is_config=True)""",
        })

    self.__supported_tag_types = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_supported_tag_types(self):
    self.__supported_tag_types = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:c-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 's-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'ietf-eth-tran-types:s-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}, 'etht-types:s-vlan-tag-type': {'@module': 'ietf-eth-tran-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-eth-tran-types'}},)), is_leaf=False, yang_name="supported-tag-types", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:eth-tag-type', is_config=True)


  def _get_vlan_range(self):
    """
    Getter method for vlan_range, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_push/outer_tag/vlan_range (etht-types:vid-range-type)

    YANG Description: In case VLAN push/swap operation is supported, the range
of available VLAN ID values.
    """
    return self.__vlan_range
      
  def _set_vlan_range(self, v, load=False):
    """
    Setter method for vlan_range, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations/vlan_push/outer_tag/vlan_range (etht-types:vid-range-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_range is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_range() directly.

    YANG Description: In case VLAN push/swap operation is supported, the range
of available VLAN ID values.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([1-9][0-9]{0,3}(-[1-9][0-9]{0,3})?(,[1-9][0-9]{0,3}(-[1-9][0-9]{0,3})?)*)'}), is_leaf=True, yang_name="vlan-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:vid-range-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_range must be of a type compatible with etht-types:vid-range-type""",
          'defined-type': "etht-types:vid-range-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([1-9][0-9]{0,3}(-[1-9][0-9]{0,3})?(,[1-9][0-9]{0,3}(-[1-9][0-9]{0,3})?)*)'}), is_leaf=True, yang_name="vlan-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:vid-range-type', is_config=True)""",
        })

    self.__vlan_range = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_range(self):
    self.__vlan_range = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([1-9][0-9]{0,3}(-[1-9][0-9]{0,3})?(,[1-9][0-9]{0,3}(-[1-9][0-9]{0,3})?)*)'}), is_leaf=True, yang_name="vlan-range", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:vid-range-type', is_config=True)

  supported_tag_types = __builtin__.property(_get_supported_tag_types, _set_supported_tag_types)
  vlan_range = __builtin__.property(_get_vlan_range, _set_vlan_range)


  _pyangbind_elements = OrderedDict([('supported_tag_types', supported_tag_types), ('vlan_range', vlan_range), ])


