# Copyright 2022-2024 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from flask.json import jsonify
from flask_restful import Resource
from nbi.service.NbiApplication import NbiApplication
from .tools.HttpStatusCodes import HTTP_CREATED, HTTP_OK

URL_PREFIX = "/restconf/data"

class BaseServer(Resource):
    def post(self):
        response = jsonify({})
        response.status_code = HTTP_CREATED
        return response

    def get(self):
        response = jsonify({})
        response.status_code = HTTP_OK
        return response

def register_restconf(nbi_app : NbiApplication):
    nbi_app.add_rest_api_resource(BaseServer, URL_PREFIX)
