# Copyright 2022-2024 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
from typing import Optional

# NOTE: Metrics disabled for now. No NBI endpoint uses it and
# causes "address already in use" when deploying multiple
# gunicorn workers.
#from prometheus_client import start_http_server

from common.Constants import ServiceNameEnum
from common.Settings import (
    ENVVAR_SUFIX_SERVICE_HOST, ENVVAR_SUFIX_SERVICE_PORT_GRPC,
    get_env_var_name, get_http_bind_address, get_log_level,

    # NOTE: Metrics disabled for now. No NBI endpoint uses it and
    # causes "address already in use" when deploying multiple
    # gunicorn workers.
    #get_metrics_port,

    get_service_baseurl_http, get_service_port_http,
    wait_for_environment_variables
)
from .NbiApplication import NbiApplication
#from .rest_server.nbi_plugins.etsi_bwm import register_etsi_bwm_api
#from .rest_server.nbi_plugins.ietf_hardware import register_ietf_hardware
#from .rest_server.nbi_plugins.ietf_l2vpn import register_ietf_l2vpn
#from .rest_server.nbi_plugins.ietf_l3vpn import register_ietf_l3vpn
#from .rest_server.nbi_plugins.ietf_network import register_ietf_network
#from .rest_server.nbi_plugins.ietf_network_slice import register_ietf_nss
#from .rest_server.nbi_plugins.ietf_acl import register_ietf_acl
#from .rest_server.nbi_plugins.qkd_app import register_qkd_app
#from .rest_server.nbi_plugins.tfs_api import register_tfs_api
#from .rest_server.nbi_plugins import register_restconf
from .websocket_namespaces.hearthbeat import register_heartbeat


LOG_LEVEL = get_log_level()
logging.basicConfig(level=LOG_LEVEL)
LOGGER = logging.getLogger(__name__)

BIND_ADDRESS = get_http_bind_address()
BIND_PORT    = get_service_port_http(ServiceNameEnum.NBI)
BASE_URL     = get_service_baseurl_http(ServiceNameEnum.NBI) or ''

REGISTER_METHODS = [
    #register_etsi_bwm_api,
    #register_ietf_hardware,
    #register_ietf_l2vpn,
    #register_ietf_l3vpn,
    #register_ietf_network,
    #register_ietf_nss,
    #register_ietf_acl,
    #register_qkd_app,
    #register_tfs_api,
    #register_restconf,
    register_heartbeat,
]

def configure_nbi(
    base_url : Optional[str] = None
) -> NbiApplication:
    wait_for_environment_variables([
        get_env_var_name(ServiceNameEnum.CONTEXT, ENVVAR_SUFIX_SERVICE_HOST     ),
        get_env_var_name(ServiceNameEnum.CONTEXT, ENVVAR_SUFIX_SERVICE_PORT_GRPC),
        get_env_var_name(ServiceNameEnum.DEVICE,  ENVVAR_SUFIX_SERVICE_HOST     ),
        get_env_var_name(ServiceNameEnum.DEVICE,  ENVVAR_SUFIX_SERVICE_PORT_GRPC),
        get_env_var_name(ServiceNameEnum.SERVICE, ENVVAR_SUFIX_SERVICE_HOST     ),
        get_env_var_name(ServiceNameEnum.SERVICE, ENVVAR_SUFIX_SERVICE_PORT_GRPC),
    ])

    LOGGER.info('Starting...')

    # Start metrics server
    # NOTE: Metrics disabled for now. No NBI endpoint uses it and
    # causes "address already in use" when deploying multiple
    # gunicorn workers.
    #metrics_port = get_metrics_port()
    #start_http_server(metrics_port)

    _nbi_app = NbiApplication(base_url=base_url)

    for register_method in REGISTER_METHODS:
        register_method(_nbi_app)

    _nbi_app.dump_configuration()

    return _nbi_app

nbi_app = configure_nbi(base_url=BASE_URL)

if __name__ == '__main__':
    # Only used to run it locally during development stage;
    # otherwise, app is directly launched by gunicorn.
    nbi_app.run_standalone(
        bind_address=BIND_ADDRESS, bind_port=BIND_PORT
    )
else:
    app = nbi_app.get_flask_app()
