/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

class EntityImageNote
extends AbstractEntityImage {
    private final TextBlock text;
    private final int xMargin = 10;
    private final int yMargin = 10;

    public EntityImageNote(IEntity iEntity) {
        super(iEntity);
        this.text = TextBlockUtils.create(iEntity.getDisplay(), new FontConfiguration(this.getFont14(), HtmlColorUtils.BLACK), HorizontalAlignment.CENTER, new SpriteContainerEmpty());
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.text.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dimension2D, 20.0, 20.0);
    }

    public void draw(ColorMapper colorMapper, Graphics2D graphics2D) {
        Dimension2D dimension2D = this.getDimension(StringBounderUtils.asStringBounder(graphics2D));
        int n = (int)dimension2D.getWidth();
        int n2 = (int)dimension2D.getHeight();
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(n - 10, 0);
        polygon.addPoint(n, 10);
        polygon.addPoint(n, n2);
        polygon.addPoint(0, n2);
        graphics2D.setColor(colorMapper.getMappedColor(this.getYellowNote()));
        graphics2D.fill(polygon);
        graphics2D.setColor(colorMapper.getMappedColor(this.getRed()));
        graphics2D.draw(polygon);
        graphics2D.drawLine(n - 10, 0, n - 10, 10);
        graphics2D.drawLine(n - 10, 10, n, 10);
        graphics2D.setColor(Color.BLACK);
    }
}

