import grpc, logging
from common.tools.client.RetryDecorator import retry, delay_exponential
from dbscanserving.proto.dbscanserving_pb2 import DetectionRequest, DetectionResponse
from dbscanserving.proto.dbscanserving_pb2_grpc import DetectorStub

LOGGER = logging.getLogger(__name__)
MAX_RETRIES = 15
DELAY_FUNCTION = delay_exponential(initial=0.01, increment=2.0, maximum=5.0)

class DbscanServingClient:
    def __init__(self, address, port):
        self.endpoint = '{:s}:{:s}'.format(str(address), str(port))
        LOGGER.debug('Creating channel to {:s}...'.format(str(self.endpoint)))
        self.channel = None
        self.stub = None
        self.connect()
        LOGGER.debug('Channel created')

    def connect(self):
        self.channel = grpc.insecure_channel(self.endpoint)
        self.stub = DetectorStub(self.channel)

    def close(self):
        if(self.channel is not None): self.channel.close()
        self.channel = None
        self.stub = None

    @retry(exceptions=set(), max_retries=MAX_RETRIES, delay_function=DELAY_FUNCTION, prepare_method_name='connect')
    def Detect(self, request : DetectionRequest) -> DetectionResponse:
        LOGGER.debug('Detect request: {:s}'.format(str(request)))
        response = self.stub.Detect(request)
        LOGGER.debug('Detect result: {:s}'.format(str(response)))
        return response
