# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


def create_kafka_config():
        """
        No input parameter is requested
        Returns the dict object with Kafka configs
        """
        _kafka_configs = dict()
        _kafka_configs['bootstrap_servers'] = '127.0.0.1:9092'
        _kafka_configs['exporter_endpoint'] = 'http://10.152.183.231:9100/metrics'
        _kafka_configs['kafka_topic']       = 'metric-data'
        _kafka_configs['run_duration']      = 20
        _kafka_configs['fetch_interval']    = 4

        return _kafka_configs

def create_kafka_config_a(bootstrap_server, exporter_endpoint, kafka_topic, run_duration, fetch_interval):
        """
        Provide ...
        Bootstrap_server IP address as String.
        Exporter endpoint with port <http://ip:port(metrics)> address as String.
        Kafka topic name as String.
        Total duration of the test as Float.
        Fetch_interval as Float.
        """
        _kafka_configs = dict()
        _kafka_configs['bootstrap_servers'] = bootstrap_server
        _kafka_configs['exporter_endpoint'] = exporter_endpoint
        _kafka_configs['kafka_topic']       = kafka_topic
        _kafka_configs['run_duration']      = run_duration
        _kafka_configs['fetch_interval']    = fetch_interval

        return _kafka_configs