# Hackfest 5 - Control an Emulated DataPlane through TeraFlowSDN

## TeraFlowSDN Deployment
```bash
cd ~/tfs-ctrl
source hackfest5/deploy_specs.sh
./deploy/all.sh
```

# ContainerLab - hackfest5 cEOS - Commands

## Download and install ContainerLab
```bash
sudo bash -c "$(curl -sL https://get.containerlab.dev)" -- -v 0.59.0
```

## Download hackfest5 cEOS image and create Docker image
- Note: Image to be downloaded for free from [Arista](https://www.arista.com/en/login) website.
```bash
cd ~/tfs-ctrl/hackfest5/images/arista
docker import cEOS64-lab-4.32.2F.tar ceos:4.32.2F
```

## Deploy scenario
```bash
~/tfs-ctrl/hackfest5/clab-deploy.sh
```

## Inspect scenario
```bash
~/tfs-ctrl/hackfest5/clab-inspect.sh
```

## Show scenario's topology
```bash
~/tfs-ctrl/hackfest5/clab-graph.sh
```

## Destroy scenario
```bash
~/tfs-ctrl/hackfest5/clab-destroy.sh
```

## Access cEOS Bash
```bash
docker exec -it clab-hackfest5-r1 bash
```

## Access cEOS CLI
```bash
docker exec -it clab-hackfest5-r1 Cli
docker exec -it clab-hackfest5-r2 Cli
```

## Configure ContainerLab clients
```bash
docker exec -it clab-hackfest5-client1 bash
    ip address add 192.168.1.10/24 dev eth1
    ip route add 192.168.2.0/24 via 192.168.1.1
    ping 192.168.2.10

docker exec -it clab-hackfest5-client2 bash
    ip address add 192.168.2.10/24 dev eth1
    ip route add 192.168.1.0/24 via 192.168.2.1
    ping 192.168.1.10
```

## Install gNMIc
```bash
sudo bash -c "$(curl -sL https://get-gnmic.kmrd.dev)"
```

## gNMI Capabilities request
```bash
gnmic --address clab-hackfest5-r1 --port 6030 --username admin --password admin --insecure capabilities
```

## gNMI Get request
```bash
gnmic --address clab-hackfest5-r1 --port 6030 --username admin --password admin --insecure --encoding json_ietf get --path / > r1.json
gnmic --address clab-hackfest5-r1 --port 6030 --username admin --password admin --insecure --encoding json_ietf get --path /interfaces/interface > r1-ifaces.json
```

## gNMI Set request
```bash
gnmic --address clab-hackfest5-r1 --port 6030 --username admin --password admin --insecure --encoding json_ietf set --update-path /system/config/hostname --update-value "my-r1"
gnmic --address clab-hackfest5-r1 --port 6030 --username admin --password admin --insecure --encoding json_ietf get --path /system/config/hostname
```

## Subscribe request
```bash
gnmic --address clab-hackfest5-r1 --port 6030 --username admin --password admin --insecure --encoding json_ietf subscribe --path /interfaces/interface[name=Management0]/state/

# In another terminal, you can generate traffic opening SSH connection
ssh admin@clab-hackfest5-r1
```

# Check configurations done:
```bash
gnmic --address clab-hackfest5-r1 --port 6030 --username admin --password admin --insecure --encoding json_ietf get --path '/network-instances' > r1-nis.json
gnmic --address clab-hackfest5-r1 --port 6030 --username admin --password admin --insecure --encoding json_ietf get --path '/interfaces' > r1-ifs.json
```

# Delete elements:
```bash
--address clab-hackfest5-r1 --port 6030 --username admin --password admin --insecure --encoding json_ietf set --delete '/network-instances/network-instance[name=b19229e8]'
--address clab-hackfest5-r1 --port 6030 --username admin --password admin --insecure --encoding json_ietf set --delete '/interfaces/interface[name=ethernet-1/1]/subinterfaces/subinterface[index=0]'
--address clab-hackfest5-r1 --port 6030 --username admin --password admin --insecure --encoding json_ietf set --delete '/interfaces/interface[name=ethernet-1/2]/subinterfaces/subinterface[index=0]'
```
