import sys
import grpc

from monitoring.proto import monitoring_pb2
from monitoring.proto import monitoring_pb2_grpc
from monitoring.proto import context_pb2

from common.logger import getJSONLogger
LOGGER = getJSONLogger('monitoring-client')
LOGGER.setLevel('DEBUG')

class MonitoringClient:

    def __init__(self, server='monitoring', port='7070'):
        endpoint = '{}:{}'.format(server, port)
        LOGGER.info('init monitoringClient {}'.format(endpoint))
        self.channel = grpc.insecure_channel(endpoint)
        self.server = monitoring_pb2_grpc.MonitoringServiceStub(self.channel)

    def CreateKpi(self, request):
        LOGGER.info('CreateKpi: {}'.format(request))
        response = self.server.CreateKpi(request)
        LOGGER.info('CreateKpi result: {}'.format(response))
        return monitoring_pb2.KpiId()

    def MonitorKpi(self, request):
        LOGGER.info('MonitorKpi: {}'.format(request))
        response = self.server.MonitorKpi(request)
        LOGGER.info('MonitorKpi result: {}'.format(response))
        return context_pb2.Empty()

    def MonitorDeviceKpi(self, request):
        LOGGER.info('MonitorDeviceKpi: {}'.format(request))
        response = self.server.MonitorDeviceKpi(request)
        LOGGER.info('MonitorDeviceKpi result: {}'.format(response))
        return context_pb2.Empty()

    def IncludeKpi(self, request):
        LOGGER.info('IncludeKpi: {}'.format(request))
        response = self.server.IncludeKpi(request)
        LOGGER.info('IncludeKpi result: {}'.format(response))
        return context_pb2.Empty()

    def GetStreamKpi(self, request):
        LOGGER.info('GetStreamKpi: {}'.format(request))
        response = self.server.GetStreamKpi(request)
        LOGGER.info('GetStreamKpi result: {}'.format(response))
        yield monitoring_pb2.Kpi()

    def GetInstantKpi(self, request):
        LOGGER.info('GetInstantKpi: {}'.format(request))
        response = self.server.GetInstantKpi(request)
        LOGGER.info('GetInstantKpi result: {}'.format(response))
        return monitoring_pb2.Kpi()


if __name__ == '__main__':
    # get port
    port = sys.argv[1] if len(sys.argv) > 1 else '7070'

    # form request
    kpi_request = monitoring_pb2.KpiRequest()
    kpi_request.device_id.device_id = 'KPIID0000' # pylint: disable=maybe-no-member
    kpi_request.kpiDescription = 'KPI Description'
    kpi_request.kpi_sample_type = monitoring_pb2.KpiSampleType.PACKETS_TRANSMITTED

    # make call to server
    client = MonitoringClient(port=port)
    response=client.IncludeKpi(kpi_request)
