package eu.teraflow.automation;

import automation.Automation;
import context.ContextOuterClass;
import eu.teraflow.automation.device.model.DeviceId;
import eu.teraflow.automation.device.model.Uuid;
import eu.teraflow.automation.model.DeviceRole;
import eu.teraflow.automation.model.DeviceRoleId;
import eu.teraflow.automation.model.DeviceRoleType;
import io.quarkus.grpc.GrpcService;
import io.smallrye.mutiny.Uni;
import javax.inject.Inject;

@GrpcService
public class AutomationGatewayImpl implements AutomationGateway {

    private final AutomationService automationService;

    @Inject
    public AutomationGatewayImpl(AutomationService automationService) {
        this.automationService = automationService;
    }

    @Override
    public Uni<Automation.DeviceRole> ztpGetDeviceRole(Automation.DeviceRoleId request) {
        return Uni.createFrom()
                .item(() -> Automation.DeviceRole.newBuilder().setDevRoleId(request).build());
    }

    @Override
    public Uni<Automation.DeviceRoleList> ztpGetDeviceRolesByDeviceId(
            ContextOuterClass.DeviceId request) {
        return Uni.createFrom().item(() -> Automation.DeviceRoleList.newBuilder().build());
    }

    @Override
    public Uni<Automation.DeviceRoleState> ztpAdd(Automation.DeviceRole request) {

        automationService.ztpAdd(getDeviceRole(request));

        return Uni.createFrom()
                .item(
                        () ->
                                Automation.DeviceRoleState.newBuilder()
                                        .setDevRoleId(request.getDevRoleId())
                                        .build());
    }

    @Override
    public Uni<Automation.DeviceRoleState> ztpUpdate(Automation.DeviceRole request) {
        return Uni.createFrom()
                .item(
                        () ->
                                Automation.DeviceRoleState.newBuilder()
                                        .setDevRoleId(request.getDevRoleId())
                                        .build());
    }

    @Override
    public Uni<Automation.DeviceRoleState> ztpDelete(Automation.DeviceRole request) {
        return Uni.createFrom()
                .item(
                        () ->
                                Automation.DeviceRoleState.newBuilder()
                                        .setDevRoleId(request.getDevRoleId())
                                        .build());
    }

    @Override
    public Uni<Automation.DeviceRoleState> ztpDeleteAllByDeviceId(
            ContextOuterClass.DeviceId request) {
        return Uni.createFrom().item(() -> Automation.DeviceRoleState.newBuilder().build());
    }

    private DeviceRole getDeviceRole(Automation.DeviceRole deviceRole) {
        final var OutDeviceId = deviceRole.getDevRoleId().getDevId().getDeviceUuid();

        Uuid uuid = new Uuid(OutDeviceId.getUuid());
        DeviceId deviceId = new DeviceId(uuid);

        DeviceRoleId deviceRoleId = new DeviceRoleId(uuid, deviceId);

        final var deviceRoleType = deviceRole.getDevRoleType();

        if (deviceRoleType == Automation.DeviceRoleType.DEV_OPS) {
            return new DeviceRole(deviceRoleId, DeviceRoleType.DEV_OPS);
        } else if (deviceRoleType == Automation.DeviceRoleType.DEV_CONF) {
            return new DeviceRole(deviceRoleId, DeviceRoleType.DEV_CONF);
        } else if (deviceRoleType == Automation.DeviceRoleType.NONE) {
            return new DeviceRole(deviceRoleId, DeviceRoleType.NONE);
        } else {
            return new DeviceRole(deviceRoleId, DeviceRoleType.PIPELINE_CONF);
        }
    }
}
