# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import label_restrictions
from . import underlay
from . import path_constraints
from . import optimizations
from . import path_properties
from . import local_link_connectivity
class local_link_connectivities(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/tunnel-termination-point/local-link-connectivities. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Contains an LLCL for a TTP on a TE node.
  """
  __slots__ = ('_path_helper', '_extmethods', '__number_of_entries','__label_restrictions','__is_allowed','__underlay','__path_constraints','__optimizations','__path_properties','__local_link_connectivity',)

  _yang_name = 'local-link-connectivities'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__number_of_entries = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="number-of-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint16', is_config=True)
    self.__label_restrictions = YANGDynClass(base=label_restrictions.label_restrictions, is_container='container', yang_name="label-restrictions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__is_allowed = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="is-allowed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=True)
    self.__underlay = YANGDynClass(base=underlay.underlay, is_container='container', yang_name="underlay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__path_constraints = YANGDynClass(base=path_constraints.path_constraints, is_container='container', yang_name="path-constraints", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__optimizations = YANGDynClass(base=optimizations.optimizations, is_container='container', yang_name="optimizations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__path_properties = YANGDynClass(base=path_properties.path_properties, is_container='container', yang_name="path-properties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__local_link_connectivity = YANGDynClass(base=YANGListType("link_tp_ref",local_link_connectivity.local_link_connectivity, yang_name="local-link-connectivity", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='link-tp-ref', extensions=None), is_container='list', yang_name="local-link-connectivity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'tunnel-termination-point', 'local-link-connectivities']

  def _get_number_of_entries(self):
    """
    Getter method for number_of_entries, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/number_of_entries (uint16)

    YANG Description: The number of LLCL entries.
If this number is specified in the configuration request,
the number is the requested number of entries, which may
not all be listed in the list;
if this number is reported in the state data,
the number is the current number of operational entries.
    """
    return self.__number_of_entries
      
  def _set_number_of_entries(self, v, load=False):
    """
    Setter method for number_of_entries, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/number_of_entries (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_number_of_entries is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_number_of_entries() directly.

    YANG Description: The number of LLCL entries.
If this number is specified in the configuration request,
the number is the requested number of entries, which may
not all be listed in the list;
if this number is reported in the state data,
the number is the current number of operational entries.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="number-of-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """number_of_entries must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="number-of-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint16', is_config=True)""",
        })

    self.__number_of_entries = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_number_of_entries(self):
    self.__number_of_entries = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="number-of-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint16', is_config=True)


  def _get_label_restrictions(self):
    """
    Getter method for label_restrictions, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/label_restrictions (container)

    YANG Description: The label restrictions container.
    """
    return self.__label_restrictions
      
  def _set_label_restrictions(self, v, load=False):
    """
    Setter method for label_restrictions, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/label_restrictions (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_label_restrictions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_label_restrictions() directly.

    YANG Description: The label restrictions container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=label_restrictions.label_restrictions, is_container='container', yang_name="label-restrictions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """label_restrictions must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=label_restrictions.label_restrictions, is_container='container', yang_name="label-restrictions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__label_restrictions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_label_restrictions(self):
    self.__label_restrictions = YANGDynClass(base=label_restrictions.label_restrictions, is_container='container', yang_name="label-restrictions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_is_allowed(self):
    """
    Getter method for is_allowed, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/is_allowed (boolean)

    YANG Description: 'true' - switching is allowed;
'false' - switching is disallowed.
    """
    return self.__is_allowed
      
  def _set_is_allowed(self, v, load=False):
    """
    Setter method for is_allowed, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/is_allowed (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_is_allowed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_is_allowed() directly.

    YANG Description: 'true' - switching is allowed;
'false' - switching is disallowed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="is-allowed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """is_allowed must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="is-allowed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=True)""",
        })

    self.__is_allowed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_is_allowed(self):
    self.__is_allowed = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="is-allowed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=True)


  def _get_underlay(self):
    """
    Getter method for underlay, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/underlay (container)

    YANG Description: Attributes of the TE link underlay.
    """
    return self.__underlay
      
  def _set_underlay(self, v, load=False):
    """
    Setter method for underlay, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/underlay (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_underlay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_underlay() directly.

    YANG Description: Attributes of the TE link underlay.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=underlay.underlay, is_container='container', yang_name="underlay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """underlay must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=underlay.underlay, is_container='container', yang_name="underlay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__underlay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_underlay(self):
    self.__underlay = YANGDynClass(base=underlay.underlay, is_container='container', yang_name="underlay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_path_constraints(self):
    """
    Getter method for path_constraints, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/path_constraints (container)

    YANG Description: TE named path constraints container.
    """
    return self.__path_constraints
      
  def _set_path_constraints(self, v, load=False):
    """
    Setter method for path_constraints, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/path_constraints (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_constraints is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_constraints() directly.

    YANG Description: TE named path constraints container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=path_constraints.path_constraints, is_container='container', yang_name="path-constraints", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_constraints must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=path_constraints.path_constraints, is_container='container', yang_name="path-constraints", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__path_constraints = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_constraints(self):
    self.__path_constraints = YANGDynClass(base=path_constraints.path_constraints, is_container='container', yang_name="path-constraints", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_optimizations(self):
    """
    Getter method for optimizations, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/optimizations (container)

    YANG Description: The objective function container that includes
attributes to impose when computing a TE path.
    """
    return self.__optimizations
      
  def _set_optimizations(self, v, load=False):
    """
    Setter method for optimizations, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/optimizations (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_optimizations is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_optimizations() directly.

    YANG Description: The objective function container that includes
attributes to impose when computing a TE path.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=optimizations.optimizations, is_container='container', yang_name="optimizations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """optimizations must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=optimizations.optimizations, is_container='container', yang_name="optimizations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__optimizations = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_optimizations(self):
    self.__optimizations = YANGDynClass(base=optimizations.optimizations, is_container='container', yang_name="optimizations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_path_properties(self):
    """
    Getter method for path_properties, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/path_properties (container)

    YANG Description: The TE path properties.
    """
    return self.__path_properties
      
  def _set_path_properties(self, v, load=False):
    """
    Setter method for path_properties, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/path_properties (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_properties is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_properties() directly.

    YANG Description: The TE path properties.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=path_properties.path_properties, is_container='container', yang_name="path-properties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_properties must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=path_properties.path_properties, is_container='container', yang_name="path-properties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__path_properties = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_properties(self):
    self.__path_properties = YANGDynClass(base=path_properties.path_properties, is_container='container', yang_name="path-properties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_local_link_connectivity(self):
    """
    Getter method for local_link_connectivity, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity (list)

    YANG Description: The termination capabilities between the TTP and the LTP.
This capability information can be used to compute
the tunnel path.
The Interface Adjustment Capability Descriptors (IACDs)
(defined in RFC 6001) on each LTP can be derived from
this list.
    """
    return self.__local_link_connectivity
      
  def _set_local_link_connectivity(self, v, load=False):
    """
    Setter method for local_link_connectivity, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_local_link_connectivity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_local_link_connectivity() directly.

    YANG Description: The termination capabilities between the TTP and the LTP.
This capability information can be used to compute
the tunnel path.
The Interface Adjustment Capability Descriptors (IACDs)
(defined in RFC 6001) on each LTP can be derived from
this list.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("link_tp_ref",local_link_connectivity.local_link_connectivity, yang_name="local-link-connectivity", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='link-tp-ref', extensions=None), is_container='list', yang_name="local-link-connectivity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """local_link_connectivity must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("link_tp_ref",local_link_connectivity.local_link_connectivity, yang_name="local-link-connectivity", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='link-tp-ref', extensions=None), is_container='list', yang_name="local-link-connectivity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)""",
        })

    self.__local_link_connectivity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_local_link_connectivity(self):
    self.__local_link_connectivity = YANGDynClass(base=YANGListType("link_tp_ref",local_link_connectivity.local_link_connectivity, yang_name="local-link-connectivity", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='link-tp-ref', extensions=None), is_container='list', yang_name="local-link-connectivity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)

  number_of_entries = __builtin__.property(_get_number_of_entries, _set_number_of_entries)
  label_restrictions = __builtin__.property(_get_label_restrictions, _set_label_restrictions)
  is_allowed = __builtin__.property(_get_is_allowed, _set_is_allowed)
  underlay = __builtin__.property(_get_underlay, _set_underlay)
  path_constraints = __builtin__.property(_get_path_constraints, _set_path_constraints)
  optimizations = __builtin__.property(_get_optimizations, _set_optimizations)
  path_properties = __builtin__.property(_get_path_properties)
  local_link_connectivity = __builtin__.property(_get_local_link_connectivity, _set_local_link_connectivity)


  _pyangbind_elements = OrderedDict([('number_of_entries', number_of_entries), ('label_restrictions', label_restrictions), ('is_allowed', is_allowed), ('underlay', underlay), ('path_constraints', path_constraints), ('optimizations', optimizations), ('path_properties', path_properties), ('local_link_connectivity', local_link_connectivity), ])


