package eu.teraflow.automation.device.model;

import java.util.List;
import java.util.stream.Collectors;

public class DeviceConfig {

    private final List<ConfigRule> configRules;

    public DeviceConfig(List<ConfigRule> configRules) {

        this.configRules = configRules;
    }

    public List<ConfigRule> getConfigRules() {
        return configRules;
    }

    @Override
    public String toString() {
        final var configRulesDescription =
                configRules.stream().map(ConfigRule::toString).collect(Collectors.joining(", "));
        return String.format("%s[%s]", getClass().getSimpleName(), configRulesDescription);
    }
}
