# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#      http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from .protos import grpcService_pb2_grpc
from .protos import grpcService_pb2

import logging
LOGGER = logging.getLogger(__name__)
import os

# AUTOGENERATED
class UpdateRequest:
    def __init__(self, address_family_id, next_hop, as_path_segment, nodes, links):
        self.address_family_id = address_family_id
        self.next_hop = next_hop
        self.as_path_segment = as_path_segment
        self.nodes = nodes
        self.links = links
    
    @classmethod
    def from_proto(cls, update_request):
        nodes = []
        for node in update_request.node:
            nodes.append(NodeInfo.from_proto(node))

        links = []
        for link in update_request.link:
            links.append(LinkInfo.from_proto(link))

        return cls(
            address_family_id=update_request.addressFamilyID,
            next_hop=update_request.nextHop,
            as_path_segment=update_request.asPathSegment,
            nodes=nodes,
            links=links
        )
    def toString(self):
      # Debug purposes
      out = ""
      out+=self.address_family_id
      out+=self.next_hop
      out+=self.as_path_segment

      for node in self.nodes:
          out+=node.node_name
          out+=node.igp_id
          out+=str(node.bgpls_id)
          out+=str(node.as_id)
      for link in self.links:
          out+=link.remote_id
          out+=link.local_id
          out+=link.remote_ipv4_id
          out+=link.local_ipv4_id
          out+=str(link.local.as_number)
          out+=link.local.bgpls_id
          out+=link.remote.as_number
          out+=link.remote.bgpls_id
          out+=str(link.available_bw)
          out+=str(link.residual_bw)
          out+=str(link.utilized)
          out+=str(link.max_link_delay)
          out+=str(link.min_link_delay)
          out+=str(link.delay_variation)
          out+=str(link.delay)
          out+=str(link.te_default_metric)
          out+=str(link.adjacency_sid)
      return out

class NodeInfo:
    def __init__(self, node_name, igp_id, bgpls_id, as_id,learnt_from):
        self.node_name = node_name.strip("/")
        self.igp_id = igp_id.strip("/")
        self.bgpls_id = bgpls_id.strip("/")
        self.as_id = as_id
        self.learnt_from=learnt_from
    
    @classmethod
    def from_proto(cls, proto_node):
        return cls(
            node_name=proto_node.nodeName,
            igp_id=proto_node.igpID,
            bgpls_id=proto_node.bgplsID,
            as_id=proto_node.asID,
            learnt_from=proto_node.learntFrom
        )

class LinkInfo:
    def __init__(self, remote_id, local_id, remote_ipv4_id, local_ipv4_id, local, remote, available_bw, residual_bw, utilized, max_link_delay, min_link_delay, delay_variation, delay, te_default_metric, adjacency_sid,learnt_from):
        self.remote_id = remote_id.strip("/")
        self.local_id = local_id.strip("/")
        self.remote_ipv4_id = remote_ipv4_id.strip("/")
        self.local_ipv4_id = local_ipv4_id.strip("/")
        self.local = local
        self.remote = remote
        self.available_bw = available_bw
        self.residual_bw = residual_bw
        self.utilized = utilized
        self.max_link_delay = max_link_delay
        self.min_link_delay = min_link_delay
        self.delay_variation = delay_variation
        self.delay = delay
        self.te_default_metric = te_default_metric
        self.adjacency_sid = adjacency_sid
        self.learnt_from=learnt_from
    
    @classmethod
    def from_proto(cls, proto_link):
        return cls(
            remote_id=proto_link.remoteID,
            local_id=proto_link.localID,
            remote_ipv4_id=proto_link.remoteIPv4ID,
            local_ipv4_id=proto_link.localIPv4ID,
            local=NodeDescriptors.from_proto(proto_link.local),
            remote=NodeDescriptors.from_proto(proto_link.remote),
            available_bw=proto_link.availableBw,
            residual_bw=proto_link.residualBw,
            utilized=proto_link.utilized,
            max_link_delay=proto_link.maxLinkDelay,
            min_link_delay=proto_link.minLinkDelay,
            delay_variation=proto_link.delayVariation,
            delay=proto_link.delay,
            te_default_metric=proto_link.TEDefaultMetric,
            adjacency_sid=proto_link.adjacencySid,
            learnt_from=proto_link.learntFrom
        )

class NodeDescriptors:
    def __init__(self, as_number, bgpls_id):
        self.as_number = as_number
        self.bgpls_id = bgpls_id
        self.node_name=None
    @classmethod
    def from_proto(cls, descriptor):
        return cls(
            as_number=descriptor.asNumber,
            bgpls_id=descriptor.bgplsID
        )



"""
message Device {
  DeviceId device_id = 1;
  string name = 2;
  string device_type = 3;
  DeviceConfig device_config = 4;
  DeviceOperationalStatusEnum device_operational_status = 5;
  repeated DeviceDriverEnum device_drivers = 6;
  repeated EndPoint device_endpoints = 7;
  repeated Component component = 8; // Used for inventory
}
message DeviceId {
  Uuid device_uuid = 1;
}
message TopologyId {
  ContextId context_id = 1;
  Uuid topology_uuid = 2;
}

message Topology {
  TopologyId topology_id = 1;
  string name = 2;
  repeated DeviceId device_ids = 3;
  repeated LinkId link_ids = 4;
}

message TopologyDetails {
  TopologyId topology_id = 1;
  string name = 2;
  repeated Device devices = 3;
  repeated Link links = 4;
}
message LinkId {
  Uuid link_uuid = 1;
}

message Link {
  LinkId link_id = 1;
  string name = 2;
  repeated EndPointId link_endpoint_ids = 3;
}
"""