# 3.2. Development Commands, Tricks, and Hints (WORK IN PROGRESS)

## Building, running, testing and reporting code coverage locally

The project runs a CI/CD loops that ensures that all tests are run whenever new code is committed to our reporitory.
However, committing and waiting for the pipeline to run can take substantial time.
For this reason, we prepared a script that runs in your local machine, builds the container image and executes the tests within the image.

To use the script receives one argument that is the name of the component you want to run.
For instance, if you want to build and run the tests of the `compute` component, you can run:

```shell
scripts/build_run_report_tests_locally.sh compute
```



## Items to be addressed:
- pytest flags: --log-level=INFO --verbose -o log_cli=true -o log_file=my_log_file.log -o log_file_level=DEBUG
- code coverage
- nginx ingress grpc to enable access from external sources


# interesting Docker commands

Build by hand:
cd src
docker build -t "context:lgr-test" -f ./context/Dockerfile .

Run by hand:
docker run --rm --name lgr-test -it --env "DB_BACKEND=inmemory" --entrypoint /bin/bash context:lgr-test


## Expose gRPC ports through Ingress Controller
source `my_deploy.sh`
run script `./expose_ingress_grpc.sh`

to test:
sudo apt-get install nmap
nmap -p 1010 127.0.0.1  # test if context is reachable
should retrieve something like:
$ nmap -p 1010 127.0.0.1
Starting Nmap 7.80 ( https://nmap.org ) at 2022-07-29 15:06 UTC
Nmap scan report for localhost (127.0.0.1)
Host is up (0.00035s latency).

PORT     STATE SERVICE
1010/tcp open  surf

Nmap done: 1 IP address (1 host up) scanned in 0.07 seconds
