from copy import deepcopy
from device.proto.context_pb2 import DeviceDriverEnum, DeviceOperationalStatusEnum
from .Tools import config_rule_set, config_rule_delete

# use "deepcopy" to prevent propagating forced changes during tests

DEVICE_EMU_UUID           = 'EMULATED'
DEVICE_EMU_TYPE           = 'emulated'
DEVICE_EMU_ADDRESS        = '127.0.0.1'
DEVICE_EMU_PORT           = '0'
DEVICE_EMU_DRIVERS        = [DeviceDriverEnum.DEVICEDRIVER_UNDEFINED]

DEVICE_EMU_ID = {'device_uuid': {'uuid': DEVICE_EMU_UUID}}
DEVICE_EMU = {
    'device_id': deepcopy(DEVICE_EMU_ID),
    'device_type': DEVICE_EMU_TYPE,
    'device_config': {'config_rules': []},
    'device_operational_status': DeviceOperationalStatusEnum.DEVICEOPERATIONALSTATUS_DISABLED,
    'device_drivers': DEVICE_EMU_DRIVERS,
    'device_endpoints': [],
}

DEVICE_EMU_ENDPOINTS = [
    ('EP1', '10Gbps'),
    ('EP2', '10Gbps'),
    ('EP3', '10Gbps'),
    ('EP4', '10Gbps'),
]

DEVICE_EMU_CONNECT_RULES = [
    config_rule_set('_connect/address',  DEVICE_EMU_ADDRESS ),
    config_rule_set('_connect/port',     DEVICE_EMU_PORT    ),
    config_rule_set('_connect/settings', {'endpoints': [
        {'uuid': endpoint_uuid, 'type': endpoint_type}
        for endpoint_uuid,endpoint_type in DEVICE_EMU_ENDPOINTS
    ]}),
]

DEVICE_EMU_CONFIG_RULES = [
    config_rule_set('/dev/rsrc1/value', 'value1'),
    config_rule_set('/dev/rsrc2/value', 'value2'),
    config_rule_set('/dev/rsrc3/value', 'value3'),
]

DEVICE_EMU_RECONFIG_RULES = [
    config_rule_delete('/dev/rsrc1/value', ''),
    config_rule_set   ('/dev/rsrc10/value', 'value10'),
    config_rule_set   ('/dev/rsrc11/value', 'value11'),
    config_rule_set   ('/dev/rsrc12/value', 'value12'),
]

DEVICE_EMU_DECONFIG_RULES = [
    config_rule_delete('/dev/rsrc2/value', 'value2'),
    config_rule_delete('/dev/rsrc3/value', 'value3'),
    config_rule_delete('/dev/rsrc10/value', 'value10'),
    config_rule_delete('/dev/rsrc11/value', 'value11'),
    config_rule_delete('/dev/rsrc12/value', 'value12'),
]
