/*
* Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package eu.teraflow.policy.monitoring.model;

import eu.teraflow.policy.common.Util;
import java.util.List;

public class AlarmDescriptor {
    private final String alarmId;
    private final String alarmDescription;
    private final String name;
    private final List<String> kpiIds;
    private final List<KpiValueRange> kpiValueRanges;
    private final double timestamp;

    public AlarmDescriptor(
            String alarmId,
            String alarmDescription,
            String name,
            List<String> kpiIds,
            List<KpiValueRange> kpiValueRanges,
            double timestamp) {
        this.alarmId = alarmId;
        this.alarmDescription = alarmDescription;
        this.name = name;
        this.kpiIds = kpiIds;
        this.kpiValueRanges = kpiValueRanges;
        this.timestamp = timestamp;
    }

    public String getAlarmId() {
        return alarmId;
    }

    public String getAlarmDescription() {
        return alarmDescription;
    }

    public String getName() {
        return name;
    }

    public List<String> getKpiIds() {
        return kpiIds;
    }

    public List<KpiValueRange> getKpiValueRanges() {
        return kpiValueRanges;
    }

    public double getTimestamp() {
        return timestamp;
    }

    @Override
    public String toString() {
        return String.format(
                "%s:{alarmId:\"%s\", alarmDescription:\"%s\", name:\"%s\", [%s], [%s], timestamp:\"%f\"}",
                getClass().getSimpleName(),
                alarmId,
                alarmDescription,
                name,
                Util.toString(kpiIds),
                Util.toString(kpiValueRanges),
                timestamp);
    }
}
