# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import bundled_links
from . import component_links
from . import te_link_attributes
from . import information_source_state
from . import information_source_entry
from . import recovery
from . import underlay
from . import statistics
class te(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/link/te. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Indicates TE support.
  """
  __slots__ = ('_path_helper', '_extmethods', '__bundled_links','__component_links','__te_link_template','__te_link_attributes','__oper_status','__is_transitional','__information_source','__information_source_instance','__information_source_state','__information_source_entry','__recovery','__underlay','__statistics',)

  _yang_name = 'te'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__bundled_links = YANGDynClass(base=bundled_links.bundled_links, is_container='container', yang_name="bundled-links", parent=self, choice=('bundle-stack-level', 'bundle'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__component_links = YANGDynClass(base=component_links.component_links, is_container='container', yang_name="component-links", parent=self, choice=('bundle-stack-level', 'component'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__te_link_template = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="te-link-template", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=True)
    self.__te_link_attributes = YANGDynClass(base=te_link_attributes.te_link_attributes, is_container='container', yang_name="te-link-attributes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'up': {}, 'down': {}, 'testing': {}, 'preparing-maintenance': {}, 'maintenance': {}, 'unknown': {}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-oper-status', is_config=False)
    self.__is_transitional = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="is-transitional", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='empty', is_config=False)
    self.__information_source = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'unknown': {}, 'locally-configured': {}, 'ospfv2': {}, 'ospfv3': {}, 'isis': {}, 'bgp-ls': {}, 'system-processed': {}, 'other': {}},), is_leaf=True, yang_name="information-source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-info-source', is_config=False)
    self.__information_source_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="information-source-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)
    self.__information_source_state = YANGDynClass(base=information_source_state.information_source_state, is_container='container', yang_name="information-source-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__information_source_entry = YANGDynClass(base=YANGListType("information_source information_source_instance",information_source_entry.information_source_entry, yang_name="information-source-entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='information-source information-source-instance', extensions=None), is_container='list', yang_name="information-source-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)
    self.__recovery = YANGDynClass(base=recovery.recovery, is_container='container', yang_name="recovery", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__underlay = YANGDynClass(base=underlay.underlay, is_container='container', yang_name="underlay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__statistics = YANGDynClass(base=statistics.statistics, is_container='container', yang_name="statistics", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'link', 'te']

  def _get_bundled_links(self):
    """
    Getter method for bundled_links, mapped from YANG variable /networks/network/link/te/bundled_links (container)

    YANG Description: A set of bundled links.
    """
    return self.__bundled_links
      
  def _set_bundled_links(self, v, load=False):
    """
    Setter method for bundled_links, mapped from YANG variable /networks/network/link/te/bundled_links (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bundled_links is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bundled_links() directly.

    YANG Description: A set of bundled links.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=bundled_links.bundled_links, is_container='container', yang_name="bundled-links", parent=self, choice=('bundle-stack-level', 'bundle'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bundled_links must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=bundled_links.bundled_links, is_container='container', yang_name="bundled-links", parent=self, choice=('bundle-stack-level', 'bundle'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__bundled_links = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bundled_links(self):
    self.__bundled_links = YANGDynClass(base=bundled_links.bundled_links, is_container='container', yang_name="bundled-links", parent=self, choice=('bundle-stack-level', 'bundle'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_component_links(self):
    """
    Getter method for component_links, mapped from YANG variable /networks/network/link/te/component_links (container)

    YANG Description: A set of component links.
    """
    return self.__component_links
      
  def _set_component_links(self, v, load=False):
    """
    Setter method for component_links, mapped from YANG variable /networks/network/link/te/component_links (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_component_links is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_component_links() directly.

    YANG Description: A set of component links.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=component_links.component_links, is_container='container', yang_name="component-links", parent=self, choice=('bundle-stack-level', 'component'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """component_links must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=component_links.component_links, is_container='container', yang_name="component-links", parent=self, choice=('bundle-stack-level', 'component'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__component_links = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_component_links(self):
    self.__component_links = YANGDynClass(base=component_links.component_links, is_container='container', yang_name="component-links", parent=self, choice=('bundle-stack-level', 'component'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_te_link_template(self):
    """
    Getter method for te_link_template, mapped from YANG variable /networks/network/link/te/te_link_template (leafref)

    YANG Description: The reference to a TE link template.
    """
    return self.__te_link_template
      
  def _set_te_link_template(self, v, load=False):
    """
    Setter method for te_link_template, mapped from YANG variable /networks/network/link/te/te_link_template (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te_link_template is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te_link_template() directly.

    YANG Description: The reference to a TE link template.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="te-link-template", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te_link_template must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="te-link-template", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=True)""",
        })

    self.__te_link_template = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te_link_template(self):
    self.__te_link_template = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="te-link-template", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=True)


  def _get_te_link_attributes(self):
    """
    Getter method for te_link_attributes, mapped from YANG variable /networks/network/link/te/te_link_attributes (container)

    YANG Description: Link attributes in a TE topology.
    """
    return self.__te_link_attributes
      
  def _set_te_link_attributes(self, v, load=False):
    """
    Setter method for te_link_attributes, mapped from YANG variable /networks/network/link/te/te_link_attributes (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te_link_attributes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te_link_attributes() directly.

    YANG Description: Link attributes in a TE topology.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=te_link_attributes.te_link_attributes, is_container='container', yang_name="te-link-attributes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te_link_attributes must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=te_link_attributes.te_link_attributes, is_container='container', yang_name="te-link-attributes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__te_link_attributes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te_link_attributes(self):
    self.__te_link_attributes = YANGDynClass(base=te_link_attributes.te_link_attributes, is_container='container', yang_name="te-link-attributes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_oper_status(self):
    """
    Getter method for oper_status, mapped from YANG variable /networks/network/link/te/oper_status (te-types:te-oper-status)

    YANG Description: The current operational state of the link.
    """
    return self.__oper_status
      
  def _set_oper_status(self, v, load=False):
    """
    Setter method for oper_status, mapped from YANG variable /networks/network/link/te/oper_status (te-types:te-oper-status)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oper_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oper_status() directly.

    YANG Description: The current operational state of the link.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'up': {}, 'down': {}, 'testing': {}, 'preparing-maintenance': {}, 'maintenance': {}, 'unknown': {}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-oper-status', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oper_status must be of a type compatible with te-types:te-oper-status""",
          'defined-type': "te-types:te-oper-status",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'up': {}, 'down': {}, 'testing': {}, 'preparing-maintenance': {}, 'maintenance': {}, 'unknown': {}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-oper-status', is_config=False)""",
        })

    self.__oper_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oper_status(self):
    self.__oper_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'up': {}, 'down': {}, 'testing': {}, 'preparing-maintenance': {}, 'maintenance': {}, 'unknown': {}},), is_leaf=True, yang_name="oper-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-oper-status', is_config=False)


  def _get_is_transitional(self):
    """
    Getter method for is_transitional, mapped from YANG variable /networks/network/link/te/is_transitional (empty)

    YANG Description: Present if the link is transitional; used as an
alternative approach in lieu of 'inter-layer-lock-id'
for path computation in a TE topology covering multiple
layers or multiple regions.
    """
    return self.__is_transitional
      
  def _set_is_transitional(self, v, load=False):
    """
    Setter method for is_transitional, mapped from YANG variable /networks/network/link/te/is_transitional (empty)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_is_transitional is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_is_transitional() directly.

    YANG Description: Present if the link is transitional; used as an
alternative approach in lieu of 'inter-layer-lock-id'
for path computation in a TE topology covering multiple
layers or multiple regions.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="is-transitional", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='empty', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """is_transitional must be of a type compatible with empty""",
          'defined-type': "empty",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="is-transitional", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='empty', is_config=False)""",
        })

    self.__is_transitional = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_is_transitional(self):
    self.__is_transitional = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="is-transitional", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='empty', is_config=False)


  def _get_information_source(self):
    """
    Getter method for information_source, mapped from YANG variable /networks/network/link/te/information_source (te-info-source)

    YANG Description: Indicates the type of information source.
    """
    return self.__information_source
      
  def _set_information_source(self, v, load=False):
    """
    Setter method for information_source, mapped from YANG variable /networks/network/link/te/information_source (te-info-source)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_information_source is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_information_source() directly.

    YANG Description: Indicates the type of information source.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'unknown': {}, 'locally-configured': {}, 'ospfv2': {}, 'ospfv3': {}, 'isis': {}, 'bgp-ls': {}, 'system-processed': {}, 'other': {}},), is_leaf=True, yang_name="information-source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-info-source', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """information_source must be of a type compatible with te-info-source""",
          'defined-type': "ietf-te-topology:te-info-source",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'unknown': {}, 'locally-configured': {}, 'ospfv2': {}, 'ospfv3': {}, 'isis': {}, 'bgp-ls': {}, 'system-processed': {}, 'other': {}},), is_leaf=True, yang_name="information-source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-info-source', is_config=False)""",
        })

    self.__information_source = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_information_source(self):
    self.__information_source = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'unknown': {}, 'locally-configured': {}, 'ospfv2': {}, 'ospfv3': {}, 'isis': {}, 'bgp-ls': {}, 'system-processed': {}, 'other': {}},), is_leaf=True, yang_name="information-source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-info-source', is_config=False)


  def _get_information_source_instance(self):
    """
    Getter method for information_source_instance, mapped from YANG variable /networks/network/link/te/information_source_instance (string)

    YANG Description: The name indicating the instance of the information
source.
    """
    return self.__information_source_instance
      
  def _set_information_source_instance(self, v, load=False):
    """
    Setter method for information_source_instance, mapped from YANG variable /networks/network/link/te/information_source_instance (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_information_source_instance is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_information_source_instance() directly.

    YANG Description: The name indicating the instance of the information
source.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="information-source-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """information_source_instance must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="information-source-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)""",
        })

    self.__information_source_instance = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_information_source_instance(self):
    self.__information_source_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="information-source-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)


  def _get_information_source_state(self):
    """
    Getter method for information_source_state, mapped from YANG variable /networks/network/link/te/information_source_state (container)

    YANG Description: Contains state attributes related to the information
source.
    """
    return self.__information_source_state
      
  def _set_information_source_state(self, v, load=False):
    """
    Setter method for information_source_state, mapped from YANG variable /networks/network/link/te/information_source_state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_information_source_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_information_source_state() directly.

    YANG Description: Contains state attributes related to the information
source.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=information_source_state.information_source_state, is_container='container', yang_name="information-source-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """information_source_state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=information_source_state.information_source_state, is_container='container', yang_name="information-source-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__information_source_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_information_source_state(self):
    self.__information_source_state = YANGDynClass(base=information_source_state.information_source_state, is_container='container', yang_name="information-source-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_information_source_entry(self):
    """
    Getter method for information_source_entry, mapped from YANG variable /networks/network/link/te/information_source_entry (list)

    YANG Description: A list of information sources learned, including the source
that is used.
    """
    return self.__information_source_entry
      
  def _set_information_source_entry(self, v, load=False):
    """
    Setter method for information_source_entry, mapped from YANG variable /networks/network/link/te/information_source_entry (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_information_source_entry is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_information_source_entry() directly.

    YANG Description: A list of information sources learned, including the source
that is used.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("information_source information_source_instance",information_source_entry.information_source_entry, yang_name="information-source-entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='information-source information-source-instance', extensions=None), is_container='list', yang_name="information-source-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """information_source_entry must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("information_source information_source_instance",information_source_entry.information_source_entry, yang_name="information-source-entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='information-source information-source-instance', extensions=None), is_container='list', yang_name="information-source-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)""",
        })

    self.__information_source_entry = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_information_source_entry(self):
    self.__information_source_entry = YANGDynClass(base=YANGListType("information_source information_source_instance",information_source_entry.information_source_entry, yang_name="information-source-entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='information-source information-source-instance', extensions=None), is_container='list', yang_name="information-source-entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)


  def _get_recovery(self):
    """
    Getter method for recovery, mapped from YANG variable /networks/network/link/te/recovery (container)

    YANG Description: Status of the recovery process.
    """
    return self.__recovery
      
  def _set_recovery(self, v, load=False):
    """
    Setter method for recovery, mapped from YANG variable /networks/network/link/te/recovery (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_recovery is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_recovery() directly.

    YANG Description: Status of the recovery process.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=recovery.recovery, is_container='container', yang_name="recovery", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """recovery must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=recovery.recovery, is_container='container', yang_name="recovery", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__recovery = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_recovery(self):
    self.__recovery = YANGDynClass(base=recovery.recovery, is_container='container', yang_name="recovery", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_underlay(self):
    """
    Getter method for underlay, mapped from YANG variable /networks/network/link/te/underlay (container)

    YANG Description: State attributes for the TE link underlay.
    """
    return self.__underlay
      
  def _set_underlay(self, v, load=False):
    """
    Setter method for underlay, mapped from YANG variable /networks/network/link/te/underlay (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_underlay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_underlay() directly.

    YANG Description: State attributes for the TE link underlay.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=underlay.underlay, is_container='container', yang_name="underlay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """underlay must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=underlay.underlay, is_container='container', yang_name="underlay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__underlay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_underlay(self):
    self.__underlay = YANGDynClass(base=underlay.underlay, is_container='container', yang_name="underlay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_statistics(self):
    """
    Getter method for statistics, mapped from YANG variable /networks/network/link/te/statistics (container)

    YANG Description: Statistics data.
    """
    return self.__statistics
      
  def _set_statistics(self, v, load=False):
    """
    Setter method for statistics, mapped from YANG variable /networks/network/link/te/statistics (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_statistics is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_statistics() directly.

    YANG Description: Statistics data.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=statistics.statistics, is_container='container', yang_name="statistics", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """statistics must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=statistics.statistics, is_container='container', yang_name="statistics", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__statistics = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_statistics(self):
    self.__statistics = YANGDynClass(base=statistics.statistics, is_container='container', yang_name="statistics", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

  bundled_links = __builtin__.property(_get_bundled_links, _set_bundled_links)
  component_links = __builtin__.property(_get_component_links, _set_component_links)
  te_link_template = __builtin__.property(_get_te_link_template, _set_te_link_template)
  te_link_attributes = __builtin__.property(_get_te_link_attributes, _set_te_link_attributes)
  oper_status = __builtin__.property(_get_oper_status)
  is_transitional = __builtin__.property(_get_is_transitional)
  information_source = __builtin__.property(_get_information_source)
  information_source_instance = __builtin__.property(_get_information_source_instance)
  information_source_state = __builtin__.property(_get_information_source_state)
  information_source_entry = __builtin__.property(_get_information_source_entry)
  recovery = __builtin__.property(_get_recovery)
  underlay = __builtin__.property(_get_underlay)
  statistics = __builtin__.property(_get_statistics)

  __choices__ = {'bundle-stack-level': {'bundle': ['bundled_links'], 'component': ['component_links']}}
  _pyangbind_elements = OrderedDict([('bundled_links', bundled_links), ('component_links', component_links), ('te_link_template', te_link_template), ('te_link_attributes', te_link_attributes), ('oper_status', oper_status), ('is_transitional', is_transitional), ('information_source', information_source), ('information_source_instance', information_source_instance), ('information_source_state', information_source_state), ('information_source_entry', information_source_entry), ('recovery', recovery), ('underlay', underlay), ('statistics', statistics), ])


