# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import source
from . import destination
from . import supporting_link
from . import te
class link(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/link. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A network link connects a local (source) node and
a remote (destination) node via a set of the respective
node's termination points.  It is possible to have several
links between the same source and destination nodes.
Likewise, a link could potentially be re-homed between
termination points.  Therefore, in order to ensure that we
would always know to distinguish between links, every link
is identified by a dedicated link identifier.  Note that a
link models a point-to-point link, not a multipoint link.
  """
  __slots__ = ('_path_helper', '_extmethods', '__link_id','__source','__destination','__supporting_link','__te',)

  _yang_name = 'link'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__link_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="link-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='link-id', is_config=True)
    self.__source = YANGDynClass(base=source.source, is_container='container', yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='container', is_config=True)
    self.__destination = YANGDynClass(base=destination.destination, is_container='container', yang_name="destination", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='container', is_config=True)
    self.__supporting_link = YANGDynClass(base=YANGListType("network_ref link_ref",supporting_link.supporting_link, yang_name="supporting-link", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-ref link-ref', extensions=None), is_container='list', yang_name="supporting-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='list', is_config=True)
    self.__te = YANGDynClass(base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'link']

  def _get_link_id(self):
    """
    Getter method for link_id, mapped from YANG variable /networks/network/link/link_id (link-id)

    YANG Description: The identifier of a link in the topology.
A link is specific to a topology to which it belongs.
    """
    return self.__link_id
      
  def _set_link_id(self, v, load=False):
    """
    Setter method for link_id, mapped from YANG variable /networks/network/link/link_id (link-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_link_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_link_id() directly.

    YANG Description: The identifier of a link in the topology.
A link is specific to a topology to which it belongs.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="link-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='link-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """link_id must be of a type compatible with link-id""",
          'defined-type': "ietf-network-topology:link-id",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="link-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='link-id', is_config=True)""",
        })

    self.__link_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_link_id(self):
    self.__link_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="link-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='link-id', is_config=True)


  def _get_source(self):
    """
    Getter method for source, mapped from YANG variable /networks/network/link/source (container)

    YANG Description: This container holds the logical source of a particular
link.
    """
    return self.__source
      
  def _set_source(self, v, load=False):
    """
    Setter method for source, mapped from YANG variable /networks/network/link/source (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source() directly.

    YANG Description: This container holds the logical source of a particular
link.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=source.source, is_container='container', yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=source.source, is_container='container', yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='container', is_config=True)""",
        })

    self.__source = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source(self):
    self.__source = YANGDynClass(base=source.source, is_container='container', yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='container', is_config=True)


  def _get_destination(self):
    """
    Getter method for destination, mapped from YANG variable /networks/network/link/destination (container)

    YANG Description: This container holds the logical destination of a
particular link.
    """
    return self.__destination
      
  def _set_destination(self, v, load=False):
    """
    Setter method for destination, mapped from YANG variable /networks/network/link/destination (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination() directly.

    YANG Description: This container holds the logical destination of a
particular link.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=destination.destination, is_container='container', yang_name="destination", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=destination.destination, is_container='container', yang_name="destination", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='container', is_config=True)""",
        })

    self.__destination = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination(self):
    self.__destination = YANGDynClass(base=destination.destination, is_container='container', yang_name="destination", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='container', is_config=True)


  def _get_supporting_link(self):
    """
    Getter method for supporting_link, mapped from YANG variable /networks/network/link/supporting_link (list)

    YANG Description: Identifies the link or links on which this link depends.
    """
    return self.__supporting_link
      
  def _set_supporting_link(self, v, load=False):
    """
    Setter method for supporting_link, mapped from YANG variable /networks/network/link/supporting_link (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_supporting_link is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_supporting_link() directly.

    YANG Description: Identifies the link or links on which this link depends.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("network_ref link_ref",supporting_link.supporting_link, yang_name="supporting-link", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-ref link-ref', extensions=None), is_container='list', yang_name="supporting-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """supporting_link must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("network_ref link_ref",supporting_link.supporting_link, yang_name="supporting-link", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-ref link-ref', extensions=None), is_container='list', yang_name="supporting-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='list', is_config=True)""",
        })

    self.__supporting_link = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_supporting_link(self):
    self.__supporting_link = YANGDynClass(base=YANGListType("network_ref link_ref",supporting_link.supporting_link, yang_name="supporting-link", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-ref link-ref', extensions=None), is_container='list', yang_name="supporting-link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='list', is_config=True)


  def _get_te(self):
    """
    Getter method for te, mapped from YANG variable /networks/network/link/te (container)

    YANG Description: Indicates TE support.
    """
    return self.__te
      
  def _set_te(self, v, load=False):
    """
    Setter method for te, mapped from YANG variable /networks/network/link/te (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te() directly.

    YANG Description: Indicates TE support.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__te = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te(self):
    self.__te = YANGDynClass(base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

  link_id = __builtin__.property(_get_link_id, _set_link_id)
  source = __builtin__.property(_get_source, _set_source)
  destination = __builtin__.property(_get_destination, _set_destination)
  supporting_link = __builtin__.property(_get_supporting_link, _set_supporting_link)
  te = __builtin__.property(_get_te, _set_te)


  _pyangbind_elements = OrderedDict([('link_id', link_id), ('source', source), ('destination', destination), ('supporting_link', supporting_link), ('te', te), ])


