#!/bin/bash

PROJECTDIR=`pwd`

cd $(dirname $0)/src
RCFILE=$PROJECTDIR/coverage/.coveragerc
COVERAGEFILE=$PROJECTDIR/coverage/.coverage

# configure the correct folder on the .coveragerc file
cat $PROJECTDIR/coverage/.coveragerc.template | sed s+~/teraflow/controller+$PROJECTDIR+g > $RCFILE

# Run unitary tests and analyze coverage of code at same time

# First destroy old coverage file
rm -f $COVERAGEFILE

coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    common/database/tests/test_unitary.py \
    common/database/tests/test_engine_inmemory.py

coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    context/tests/test_unitary.py

coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    device/tests/test_unitary.py

coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    service/tests/test_unitary.py

coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    compute/tests/test_unitary.py

# Run integration tests and analyze coverage of code at same time
export DB_ENGINE='redis'
export REDIS_SERVICE_HOST='10.1.7.194'
export REDIS_SERVICE_PORT='31789'
export REDIS_DATABASE_ID='0'
coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    common/database/tests/test_engine_redis.py \
    tester_integration/test_context_device_service.py
