from enum import Enum
from device.service.database.DeviceModel import ORM_DeviceDriverEnum

class DeviceTypeFilterFieldEnum(Enum):
    EMULATED            = 'emulated'
    OPTICAL_ROADM       = 'optical-roadm'
    OPTICAL_TRANDPONDER = 'optical-trandponder'
    PACKET_ROUTER       = 'packet-router'
    PACKET_SWITCH       = 'packet-switch'

class FilterFieldEnum(Enum):
    DEVICE_TYPE   = 'device_type'
    DRIVER        = 'driver'
    VENDOR        = 'vendor'
    MODEL         = 'model'
    SERIAL_NUMBER = 'serial_number'

# Map allowed filter fields to allowed values per Filter field. If no restriction (free text) None is specified
FILTER_FIELD_ALLOWED_VALUES = {
    FilterFieldEnum.DEVICE_TYPE   : {i.value for i in DeviceTypeFilterFieldEnum},
    FilterFieldEnum.DRIVER        : {i.value for i in ORM_DeviceDriverEnum},
    FilterFieldEnum.VENDOR        : None,
    FilterFieldEnum.MODEL         : None,
    FilterFieldEnum.SERIAL_NUMBER : None,
}
