/*
* Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package eu.teraflow.policy.context;

import eu.teraflow.policy.context.model.Device;
import eu.teraflow.policy.context.model.Empty;
import eu.teraflow.policy.context.model.Service;
import eu.teraflow.policy.context.model.ServiceId;
import eu.teraflow.policy.model.PolicyRuleBasic;
import io.smallrye.mutiny.Uni;

public interface ContextService {

    Uni<Service> getService(ServiceId serviceId);

    Uni<ServiceId> setService(Service service);

    Uni<Device> getDevice(String deviceId);

    Uni<PolicyRuleBasic> getPolicyRule(String policyRuleId);

    Uni<String> setPolicyRule(PolicyRuleBasic policyRuleBasic);

    Uni<Empty> removePolicyRule(String policyRuleId);
}
