# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import supported_classification
from . import supported_vlan_operations
class eth_svc(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/termination-point/eth-svc. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: ETH LTP Service attributes.
  """
  __slots__ = ('_path_helper', '_extmethods', '__supported_classification','__supported_vlan_operations',)

  _yang_name = 'eth-svc'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__supported_classification = YANGDynClass(base=supported_classification.supported_classification, is_container='container', yang_name="supported-classification", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    self.__supported_vlan_operations = YANGDynClass(base=supported_vlan_operations.supported_vlan_operations, is_container='container', yang_name="supported-vlan-operations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'termination-point', 'eth-svc']

  def _get_supported_classification(self):
    """
    Getter method for supported_classification, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_classification (container)

    YANG Description: Service classification capability supported by the
Ethernet Link Termination Point (LTP).
    """
    return self.__supported_classification
      
  def _set_supported_classification(self, v, load=False):
    """
    Setter method for supported_classification, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_classification (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_supported_classification is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_supported_classification() directly.

    YANG Description: Service classification capability supported by the
Ethernet Link Termination Point (LTP).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=supported_classification.supported_classification, is_container='container', yang_name="supported-classification", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """supported_classification must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=supported_classification.supported_classification, is_container='container', yang_name="supported-classification", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)""",
        })

    self.__supported_classification = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_supported_classification(self):
    self.__supported_classification = YANGDynClass(base=supported_classification.supported_classification, is_container='container', yang_name="supported-classification", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)


  def _get_supported_vlan_operations(self):
    """
    Getter method for supported_vlan_operations, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations (container)

    YANG Description: Reports the VLAN operations supported by the ETH LTP.
    """
    return self.__supported_vlan_operations
      
  def _set_supported_vlan_operations(self, v, load=False):
    """
    Setter method for supported_vlan_operations, mapped from YANG variable /networks/network/node/termination_point/eth_svc/supported_vlan_operations (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_supported_vlan_operations is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_supported_vlan_operations() directly.

    YANG Description: Reports the VLAN operations supported by the ETH LTP.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=supported_vlan_operations.supported_vlan_operations, is_container='container', yang_name="supported-vlan-operations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """supported_vlan_operations must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=supported_vlan_operations.supported_vlan_operations, is_container='container', yang_name="supported-vlan-operations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)""",
        })

    self.__supported_vlan_operations = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_supported_vlan_operations(self):
    self.__supported_vlan_operations = YANGDynClass(base=supported_vlan_operations.supported_vlan_operations, is_container='container', yang_name="supported-vlan-operations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='container', is_config=True)

  supported_classification = __builtin__.property(_get_supported_classification, _set_supported_classification)
  supported_vlan_operations = __builtin__.property(_get_supported_vlan_operations, _set_supported_vlan_operations)


  _pyangbind_elements = OrderedDict([('supported_classification', supported_classification), ('supported_vlan_operations', supported_vlan_operations), ])


