# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class path_metric(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/tunnel-termination-point/local-link-connectivities/local-link-connectivity/path-properties/path-metric. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: TE path metric type.
  """
  __slots__ = ('_path_helper', '_extmethods', '__metric_type','__accumulative_value',)

  _yang_name = 'path-metric'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__metric_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="metric-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=False)
    self.__accumulative_value = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="accumulative-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'tunnel-termination-point', 'local-link-connectivities', 'local-link-connectivity', 'path-properties', 'path-metric']

  def _get_metric_type(self):
    """
    Getter method for metric_type, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/path_properties/path_metric/metric_type (identityref)

    YANG Description: TE path metric type.
    """
    return self.__metric_type
      
  def _set_metric_type(self, v, load=False):
    """
    Setter method for metric_type, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/path_properties/path_metric/metric_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_metric_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_metric_type() directly.

    YANG Description: TE path metric type.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="metric-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """metric_type must be of a type compatible with identityref""",
          'defined-type': "ietf-te-topology:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="metric-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=False)""",
        })

    self.__metric_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_metric_type(self):
    self.__metric_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-te': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-igp': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-hop': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-delay-average': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-delay-minimum': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-residual-bandwidth': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-optimize-includes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'ietf-te-types:path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}, 'te-types:path-metric-optimize-excludes': {'@module': 'ietf-te-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-te-types'}},), is_leaf=True, yang_name="metric-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='identityref', is_config=False)


  def _get_accumulative_value(self):
    """
    Getter method for accumulative_value, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/path_properties/path_metric/accumulative_value (uint64)

    YANG Description: TE path metric accumulative value.
    """
    return self.__accumulative_value
      
  def _set_accumulative_value(self, v, load=False):
    """
    Setter method for accumulative_value, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/path_properties/path_metric/accumulative_value (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_accumulative_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_accumulative_value() directly.

    YANG Description: TE path metric accumulative value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="accumulative-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """accumulative_value must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="accumulative-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint64', is_config=False)""",
        })

    self.__accumulative_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_accumulative_value(self):
    self.__accumulative_value = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="accumulative-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint64', is_config=False)

  metric_type = __builtin__.property(_get_metric_type)
  accumulative_value = __builtin__.property(_get_accumulative_value)


  _pyangbind_elements = OrderedDict([('metric_type', metric_type), ('accumulative_value', accumulative_value), ])


