# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import network
from . import te
class networks(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Serves as a top-level container for a list of networks.
  """
  __slots__ = ('_path_helper', '_extmethods', '__network','__te',)

  _yang_name = 'networks'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__network = YANGDynClass(base=YANGListType("network_id",network.network, yang_name="network", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-id', extensions=None), is_container='list', yang_name="network", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='list', is_config=True)
    self.__te = YANGDynClass(base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks']

  def _get_network(self):
    """
    Getter method for network, mapped from YANG variable /networks/network (list)

    YANG Description: Describes a network.
A network typically contains an inventory of nodes,
topological information (augmented through the
network-topology data model), and layering information.
    """
    return self.__network
      
  def _set_network(self, v, load=False):
    """
    Setter method for network, mapped from YANG variable /networks/network (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_network is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_network() directly.

    YANG Description: Describes a network.
A network typically contains an inventory of nodes,
topological information (augmented through the
network-topology data model), and layering information.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("network_id",network.network, yang_name="network", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-id', extensions=None), is_container='list', yang_name="network", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """network must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("network_id",network.network, yang_name="network", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-id', extensions=None), is_container='list', yang_name="network", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='list', is_config=True)""",
        })

    self.__network = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_network(self):
    self.__network = YANGDynClass(base=YANGListType("network_id",network.network, yang_name="network", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-id', extensions=None), is_container='list', yang_name="network", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='list', is_config=True)


  def _get_te(self):
    """
    Getter method for te, mapped from YANG variable /networks/te (container)

    YANG Description: Indicates TE support.
    """
    return self.__te
      
  def _set_te(self, v, load=False):
    """
    Setter method for te, mapped from YANG variable /networks/te (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te() directly.

    YANG Description: Indicates TE support.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__te = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te(self):
    self.__te = YANGDynClass(base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

  network = __builtin__.property(_get_network, _set_network)
  te = __builtin__.property(_get_te, _set_te)


  _pyangbind_elements = OrderedDict([('network', network), ('te', te), ])


