from copy import deepcopy
from device.proto.context_pb2 import DeviceDriverEnum, DeviceOperationalStatusEnum
from device.service.database.KpiSampleType import ORM_KpiSampleType
from .Tools import config_rule_set, config_rule_delete

# use "deepcopy" to prevent propagating forced changes during tests

DEVICE_EMU_UUID           = 'EMULATED'
DEVICE_EMU_TYPE           = 'emulated'
DEVICE_EMU_ADDRESS        = '127.0.0.1'
DEVICE_EMU_PORT           = '0'
DEVICE_EMU_DRIVERS        = [DeviceDriverEnum.DEVICEDRIVER_UNDEFINED]

DEVICE_EMU_ID = {'device_uuid': {'uuid': DEVICE_EMU_UUID}}
DEVICE_EMU = {
    'device_id': deepcopy(DEVICE_EMU_ID),
    'device_type': DEVICE_EMU_TYPE,
    'device_config': {'config_rules': []},
    'device_operational_status': DeviceOperationalStatusEnum.DEVICEOPERATIONALSTATUS_DISABLED,
    'device_drivers': DEVICE_EMU_DRIVERS,
    'device_endpoints': [],
}

PACKET_PORT_SAMPLE_TYPES = [
    ORM_KpiSampleType.PACKETS_TRANSMITTED.value,
    ORM_KpiSampleType.PACKETS_RECEIVED.value,
    ORM_KpiSampleType.BYTES_TRANSMITTED.value,
    ORM_KpiSampleType.BYTES_RECEIVED.value,
]

DEVICE_EMU_ENDPOINTS = [
    ('EP1', '10Gbps', PACKET_PORT_SAMPLE_TYPES),
    ('EP2', '10Gbps', PACKET_PORT_SAMPLE_TYPES),
    ('EP3', '10Gbps', PACKET_PORT_SAMPLE_TYPES),
    ('EP4', '10Gbps', PACKET_PORT_SAMPLE_TYPES),
]

RSRC_EP       = '/endpoints/endpoint[{}]'
RSRC_SUBIF    = RSRC_EP    + '/subinterfaces/subinterface[{}]'
RSRC_ADDRIPV4 = RSRC_SUBIF + '/ipv4/address[{}]'

DEVICE_EMU_ENDPOINTS_COOKED = []
for endpoint_uuid,endpoint_type,endpoint_sample_types in DEVICE_EMU_ENDPOINTS:
    endpoint_resource_key = RSRC_EP.format(str(endpoint_uuid))
    sample_types = {
        ORM_KpiSampleType.PACKETS_TRANSMITTED.value: '{:s}/state/packets_transmitted'.format(endpoint_resource_key),
        ORM_KpiSampleType.PACKETS_RECEIVED   .value: '{:s}/state/packets_received'   .format(endpoint_resource_key),
        ORM_KpiSampleType.BYTES_TRANSMITTED  .value: '{:s}/state/bytes_transmitted'  .format(endpoint_resource_key),
        ORM_KpiSampleType.BYTES_RECEIVED     .value: '{:s}/state/bytes_received'     .format(endpoint_resource_key),
    }
    endpoint_resource_value = {'uuid': endpoint_uuid, 'type': endpoint_type, 'sample_types': sample_types}
    DEVICE_EMU_ENDPOINTS_COOKED.append((endpoint_resource_key, endpoint_resource_value))

DEVICE_EMU_CONNECT_RULES = [
    config_rule_set('_connect/address',  DEVICE_EMU_ADDRESS ),
    config_rule_set('_connect/port',     DEVICE_EMU_PORT    ),
    config_rule_set('_connect/settings', {'endpoints': [
        {'uuid': endpoint_uuid, 'type': endpoint_type, 'sample_types': endpoint_sample_types}
        for endpoint_uuid,endpoint_type,endpoint_sample_types in DEVICE_EMU_ENDPOINTS
    ]}),
]

DEVICE_EMU_CONFIG_ENDPOINTS = [
    config_rule_set(RSRC_EP.format('EP1'), {'enabled' : True}),
    config_rule_set(RSRC_EP.format('EP2'), {'enabled' : True}),
    config_rule_set(RSRC_EP.format('EP3'), {'enabled' : True}),
    config_rule_set(RSRC_EP.format('EP4'), {'enabled' : True}),
]

DEVICE_EMU_CONFIG_ADDRESSES = [
    config_rule_set(RSRC_SUBIF   .format('EP1', 0            ), {'index': 0}),
    config_rule_set(RSRC_ADDRIPV4.format('EP1', 0, '10.1.0.1'), {'ip': '10.1.0.1', 'prefix_length': 24}),

    config_rule_set(RSRC_SUBIF   .format('EP2', 0            ), {'index': 0}),
    config_rule_set(RSRC_ADDRIPV4.format('EP2', 0, '10.2.0.1'), {'ip': '10.2.0.1', 'prefix_length': 24}),

    config_rule_set(RSRC_SUBIF   .format('EP3', 0            ), {'index': 0}),
    config_rule_set(RSRC_ADDRIPV4.format('EP3', 0, '10.3.0.1'), {'ip': '10.3.0.1', 'prefix_length': 24}),

    config_rule_set(RSRC_SUBIF   .format('EP4', 0            ), {'index': 0}),
    config_rule_set(RSRC_ADDRIPV4.format('EP4', 0, '10.4.0.1'), {'ip': '10.4.0.1', 'prefix_length': 24}),
]

DEVICE_EMU_RECONFIG_ADDRESSES = [
    config_rule_delete(RSRC_SUBIF   .format('EP2', 0            ), {}),
    config_rule_delete(RSRC_ADDRIPV4.format('EP2', 0, '10.2.0.1'), {'ip': '10.2.0.1', 'prefix_length': 24}),

    config_rule_set   (RSRC_SUBIF   .format('EP2', 1            ), {'index': 1}),
    config_rule_set   (RSRC_ADDRIPV4.format('EP2', 1, '10.2.1.1'), {'ip': '10.2.1.1', 'prefix_length': 24}),
]

DEVICE_EMU_DECONFIG_ADDRESSES = [
    config_rule_delete(RSRC_SUBIF   .format('EP1', 0            ), {}),
    config_rule_delete(RSRC_ADDRIPV4.format('EP1', 0, '10.1.0.1'), {}),

    config_rule_delete(RSRC_SUBIF   .format('EP2', 1            ), {}),
    config_rule_delete(RSRC_ADDRIPV4.format('EP2', 1, '10.2.1.1'), {}),

    config_rule_delete(RSRC_SUBIF   .format('EP3', 0            ), {}),
    config_rule_delete(RSRC_ADDRIPV4.format('EP3', 0, '10.3.0.1'), {}),

    config_rule_delete(RSRC_SUBIF   .format('EP4', 0            ), {}),
    config_rule_delete(RSRC_ADDRIPV4.format('EP4', 0, '10.4.0.1'), {}),
]

DEVICE_EMU_DECONFIG_ENDPOINTS = [
    config_rule_delete(RSRC_EP.format('EP1'), {}),
    config_rule_delete(RSRC_EP.format('EP2'), {}),
    config_rule_delete(RSRC_EP.format('EP3'), {}),
    config_rule_delete(RSRC_EP.format('EP4'), {}),
]
