from __future__ import annotations
from typing import TYPE_CHECKING, Dict
from ..entity._Entity import _Entity
from .Endpoint import Endpoint
from .Keys import KEY_LINK_ENDPOINT

if TYPE_CHECKING:
    from .Context import Context
    from .Topology import Topology
    from .Link import Link

VALIDATORS = {
    'device_uuid': lambda v: v is not None and isinstance(v, str) and (len(v) > 0),
    'endpoint_uuid': lambda v: v is not None and isinstance(v, str) and (len(v) > 0),
}

TRANSCODERS = {} # no transcoding applied to attributes

class LinkEndpoint(_Entity):
    def __init__(self, link_endpoint_uuid : str, parent : 'Link'):
        super().__init__(parent, link_endpoint_uuid, KEY_LINK_ENDPOINT, VALIDATORS, TRANSCODERS)

    @property
    def parent(self) -> 'Link': return self._parent

    @property
    def context(self) -> 'Context': return self.parent.context

    @property
    def context_uuid(self) -> str: return self.parent.context_uuid

    @property
    def topology(self) -> 'Topology': return self.parent.topology

    @property
    def topology_uuid(self) -> str: return self.parent.topology_uuid

    @property
    def link(self) -> 'Link': return self.parent

    @property
    def link_uuid(self) -> str: return self.parent.link_uuid

    @property
    def link_endpoint_uuid(self) -> str: return self._entity_uuid

    def create(self, endpoint : Endpoint) -> 'LinkEndpoint':
        self.update(update_attributes={
            'device_uuid': endpoint.device_uuid,
            'endpoint_uuid': endpoint.endpoint_uuid,
        })
        self.parent.endpoints.add(self.link_endpoint_uuid)
        return self

    def update(self, update_attributes={}, remove_attributes=[]) -> 'LinkEndpoint':
        self.attributes.update(update_attributes=update_attributes, remove_attributes=remove_attributes)
        return self

    def delete(self) -> None:
        self.attributes.delete()
        self.parent.endpoints.delete(self.link_endpoint_uuid)

    def dump_id(self) -> Dict:
        attributes = self.attributes.get()
        device_uuid = attributes.get('device_uuid', None)
        endpoint_uuid = attributes.get('endpoint_uuid', None)
        endpoint = self.topology.device(device_uuid).endpoint(endpoint_uuid)
        return endpoint.dump_id()

    def dump(self) -> Dict:
        return self.dump_id()
