/*
 * Decompiled with CFR 0.152.
 */
package jcckit.renderer;

import java.awt.Graphics2D;
import jcckit.graphic.Anchor;
import jcckit.graphic.ClippingRectangle;
import jcckit.graphic.GraphPoint;

public class Transformation {
    private final double _scale;
    private final double _x0;
    private final double _y0;

    public String toString() {
        return "_scale=" + this._scale + " _x0=" + this._x0 + " _y0=" + this._y0;
    }

    public Transformation(int n, int n2, ClippingRectangle clippingRectangle, Anchor anchor, Anchor anchor2) {
        double d = clippingRectangle.getMaxX() - clippingRectangle.getMinX();
        double d2 = clippingRectangle.getMaxY() - clippingRectangle.getMinY();
        this._scale = Math.min((double)n / d, (double)n2 / d2);
        this._x0 = 0.5 * (double)anchor.getFactor() * ((double)n - this._scale * d) - this._scale * clippingRectangle.getMinX();
        this._y0 = 0.5 * (double)anchor2.getFactor() * (this._scale * d2 - (double)n2) + (double)n2 + this._scale * clippingRectangle.getMinY();
    }

    public int transformX(double d) {
        return Transformation.trim(this._scale * d + this._x0);
    }

    public int transformY(double d) {
        return Transformation.trim(this._y0 - this._scale * d);
    }

    public int transformWidth(double d) {
        return Transformation.trim(this._scale * d + 0.5);
    }

    public int transformHeight(double d) {
        return Transformation.trim(this._scale * d + 0.5);
    }

    private static int trim(double d) {
        return d > 32767.0 ? Short.MAX_VALUE : (d < -32768.0 ? Short.MIN_VALUE : (int)d);
    }

    public GraphPoint transformBack(int n, int n2) {
        return new GraphPoint(((double)n - this._x0) / this._scale, (this._y0 - (double)n2) / this._scale);
    }

    public void apply(Graphics2D graphics2D) {
        graphics2D.translate(this._x0, this._y0);
        graphics2D.scale(this._scale, -this._scale);
    }
}

