# Mock IETF ACTN SDN Controller

This REST server implements very basic support for the following YANG data models:
- IETF YANG Data Model for Transport Network Client Signals (draft-ietf-ccamp-client-signal-yang-10)
  - Ref: https://datatracker.ietf.org/doc/draft-ietf-ccamp-client-signal-yang/
- IETF YANG Data Model for Traffic Engineering Tunnels, Label Switched Paths and Interfaces (draft-ietf-teas-yang-te-34)
  - Ref: https://datatracker.ietf.org/doc/draft-ietf-teas-yang-te/

The aim of this server is to enable testing the IetfActnDeviceDriver and the IetfActnServiceHandler.
Follow the steps below to perform the test:

## 1. Deploy TeraFlowSDN controller and the scenario
Deploy the test scenario "ietf_actn_deploy.sh":
```bash
source src/tests/tools/mock_ietf_actn_sdn_ctrl/scenario/ietf_actn_deploy.sh
./deploy/all.sh
```

## 2. Install requirements and run the Mock IETF ACTN SDN controller
__NOTE__: if you run the Mock IETF ACTN SDN controller from the PyEnv used for developping on the TeraFlowSDN framework,
all the requirements are already in place. Install them only if you execute it in a separate/standalone environment.

Install the required dependencies as follows:
```bash
pip install Flask==2.1.3 Flask-RESTful==0.3.9
```

Run the Mock IETF ACTN SDN Controller as follows:
```bash
python src/tests/tools/mock_ietf_actn_sdn_ctrl/MockIetfActnSdnCtrl.py
```

## 3. Deploy the test descriptors
Edit the descriptors to meet your environment specifications.
Edit "network_descriptors.json" and change IP address and port of the IETF ACTN SDN controller of the "ACTN" device.
- Set value of config rule "_connect/address" to the address of the host where the Mock IETF ACTN SDN controller is
  running (default="192.168.1.1").
- Set value of config rule "_connect/port" to the port where your Mock IETF ACTN SDN controller is listening on
  (default="8443").

Upload the "network_descriptors.json" through the TeraFlowSDN WebUI.
- If not already selected, select Context(admin)/Topology(admin).
- Check that a network topology with 4 routers + 1 IETF ACTN radio system are loaded. They should form 2 rings.

Upload the "service_descriptor.json" through the TeraFlowSDN WebUI.
- Check that 2 services have been created.
- The "actn-svc" should have a connection and be supported by a sub-service.
- The sub-service should also have a connection.
- The R1, R3, and MW devices should have configuration rules established.

# 4. Delete the IETF ACTN service
Find the "mw-svc" on the WebUI, navigate to its details, and delete the service pressing the "Delete Service" button.
The service, sub-service, and device configuration rules should be removed.
