from flask.app import Flask
from flask.helpers import url_for
import pytest
# from device.client.DeviceClient import DeviceClient
from webui.service import create_app

# @pytest.fixture(scope='session')
# def device_client(device_service):
#     _client = DeviceClient(address='127.0.0.1', port=100)
#     yield _client
#     _client.close()

@pytest.fixture
def app():

    app = create_app(use_config={'TESTING': True, 
                                 'SERVER_NAME': 'localhost.localdomain',
                                 'SECRET_KEY': '>s&}24@{]]#k3&^5$f3#?6?h3{W@[}/7z}2pa]>{3&5%RP<)[(',
                                 'WTF_CSRF_ENABLED': False})

    yield app

@pytest.fixture
def client(app):
    with app.test_client() as client:
        yield client
    # return app.test_client()

def test_routes(app):
    with app.app_context():
        url = url_for('main.home')
        url = url_for('service.home')
        url = url_for('device.home')

def test_service_up(client):
    rw = client.get('/')
    assert rw.status_code == 200, 'Service is not up!'

def test_home_page(client):
    rw = client.get('/')
    assert rw.status_code == 200, 'Error in the home page!'
    assert b'Select the working context' in rw.data

def test_service_home_page(client):
    with client.session_transaction() as sess:
        sess['context_uuid'] = 'admin'
    rw = client.get('/service/')
    assert rw.status_code == 200
    assert b'Services' in rw.data
    assert b'Add New Service' in rw.data

def test_device_home_page(client):
    with client.session_transaction() as sess:
        sess['context_uuid'] = 'admin'
    rw = client.get('/device/')
    assert rw.status_code == 200
    assert b'Devices' in rw.data
    assert b'Add New Device' in rw.data

@pytest.mark.parametrize('device_id', (
    'DEV1',
    'DEV2',
    'DEV3',
))
def test_device_detail_page(client, device_id):
    with client.session_transaction() as sess:
        sess['context_uuid'] = 'admin'
    rw = client.get(f'/device/detail/{device_id}')
    assert rw.status_code == 200
    assert b'Device' in rw.data
    assert device_id in rw.data.decode()
    assert b'Endpoints' in rw.data, 'Missing endpoint information on the device detail page.'
    # assert b'Add New Device' in rw.data

def test_device_add_page(client):
    with client.session_transaction() as sess:
        sess['context_uuid'] = 'admin'
    rw = client.get('/device/add')
    assert rw.status_code == 200
    assert b'Add New Device' in rw.data
    assert b'Operational Status' in rw.data, 'Form is not correctly implemented.'
    assert b'Type' in rw.data, 'Form is not correctly implemented.'
    assert b'Configurations' in rw.data, 'Form is not correctly implemented.'
    assert b'Drivers' in rw.data, 'Form is not correctly implemented.'

def test_device_add_action(client):
    with client.session_transaction() as sess:
        sess['context_uuid'] = 'admin'
    DEVICE_EMU = {
        'device_id': 'EMULATED',
        'device_type': 'emulated',
        'device_config': '',
        'operational_status': 1,
        'device_drivers': 0,
        'device_endpoints': [],
    }
    rw = client.post('/device/add', data=DEVICE_EMU, follow_redirects=True)
    assert b'success' in rw.data
