import os
from flask import Flask, session


def get_working_context() -> str:
    if 'context_uuid' in session:
        return session['context_uuid']
    else:
        return 'Not selected'


def create_app(use_config=None):
    app = Flask(__name__)
    if use_config:
        app.config.from_mapping(**use_config)

    from webui.service.main.routes import main
    app.register_blueprint(main)

    from webui.service.service.routes import service
    app.register_blueprint(service)

    from webui.service.device.routes import device
    app.register_blueprint(device)

    app.jinja_env.globals.update(get_working_context=get_working_context)

    return app
