import sys
import grpc

from . import monitoring_pb2
from . import monitoring_pb2_grpc
from . import context_pb2

#import json

from .logger import getJSONLogger
LOGGER = getJSONLogger('monitoring-client')
LOGGER.setLevel('DEBUG')

class MonitoringClient:

    def __init__(self, server='monitoring', port='7070'):
        endpoint = '{}:{}'.format(server, port)
        LOGGER.info('init monitoringClient {}'.format(endpoint))
        self.channel = grpc.insecure_channel(endpoint)
        self.server = monitoring_pb2_grpc.MonitoringServiceStub(self.channel)

    def IncludeKpi(self, request):
        LOGGER.info('IncludeKpi: {}'.format(request))
        response = self.server.IncludeKpi(request)
        LOGGER.info('IncludeKpi result: {}'.format(response))
        return context_pb2.Empty()

    def MonitorKpi(self, request):
        LOGGER.info('MonitorKpi: {}'.format(request))
        response = self.server.MonitorKpi(request)
        LOGGER.info('MonitorKpi result: {}'.format(response))
        return context_pb2.Empty()

    def GetStream_kpi(self, request):
        LOGGER.info('GetStream_kpi: {}'.format(request))
        response = self.server.GetStream_kpi(request)
        LOGGER.info('GetStream_kpi result: {}'.format(response))
        yield response

    def GetInstantKpi(self, request):
        LOGGER.info('GetInstantKpi: {}'.format(request))
        response = self.server.GetInstantKpi(request)
        LOGGER.info('GetInstantKpi result: {}'.format(response))
        return response


if __name__ == '__main__':
    # get port
    port = sys.argv[1] if len(sys.argv) > 1 else '7070'

    # form request
    kpi = monitoring_pb2.Kpi()
    kpi.kpi_id.kpi_id = 'KPIID0000' # pylint: disable=maybe-no-member
    kpi.kpiDescription = 'KPI Desc'

    # make call to server
    client = MonitoringClient(port=port)
    response=client.IncludeKpi(kpi)
