from flask.json import jsonify
from flask_restful import Resource
from common.database.api.Database import Database
from common.database.api.context.Constants import DEFAULT_CONTEXT_ID

class Context(Resource):
    def __init__(self, database : Database) -> None:
        super().__init__()
        self.database = database

    def get(self):
        with self.database:
            return jsonify(self.database.context(DEFAULT_CONTEXT_ID).dump())
