# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import sys
import grpc

from monitoring.proto import monitoring_pb2
from monitoring.proto import monitoring_pb2_grpc
from monitoring.proto import context_pb2

from common.logger import getJSONLogger
LOGGER = getJSONLogger('monitoring-client')
LOGGER.setLevel('DEBUG')

class MonitoringClient:

    def __init__(self, server='monitoring', port='7070'):
        endpoint = '{}:{}'.format(server, port)
        LOGGER.info('init monitoringClient {}'.format(endpoint))
        self.channel = grpc.insecure_channel(endpoint)
        self.server = monitoring_pb2_grpc.MonitoringServiceStub(self.channel)

    def CreateKpi(self, request):
        LOGGER.info('CreateKpi: {}'.format(request))
        response = self.server.CreateKpi(request)
        LOGGER.info('CreateKpi result: {}'.format(response))
        return response

    def EditKpiDescriptor(self, request):
        LOGGER.info('EditKpiDescriptor: {}'.format(request))
        response = self.server.EditKpiDescriptor(request)
        LOGGER.info('EditKpiDescriptor result: {}'.format(response))
        return response

    def DeleteKpi(self, request):
        LOGGER.info('DeleteKpi: {}'.format(request))
        response = self.server.DeleteKpi(request)
        LOGGER.info('DeleteKpi result: {}'.format(response))
        return response

    def GetKpiDescriptorList(self, request):
        LOGGER.info('GetKpiDescriptorList: {}'.format(request))
        response = self.server.GetKpiDescriptorList(request)
        LOGGER.info('GetKpiDescriptorList result: {}'.format(response))
        return response

    def CreateBundleKpi(self, request):
        LOGGER.info('CreateBundleKpi: {}'.format(request))
        response = self.server.CreateBundleKpi(request)
        LOGGER.info('CreateBundleKpi result: {}'.format(response))
        return response

    def GetKpiDescriptor(self, request):
        LOGGER.info('GetKpiDescriptor: {}'.format(request))
        response = self.server.GetKpiDescriptor(request)
        LOGGER.info('GetKpiDescriptor result: {}'.format(response))
        return response

    def MonitorKpi(self, request):
        LOGGER.info('MonitorKpi: {}'.format(request))
        response = self.server.MonitorKpi(request)
        LOGGER.info('MonitorKpi result: {}'.format(response))
        return response

    def IncludeKpi(self, request):
        LOGGER.info('IncludeKpi: {}'.format(request))
        response = self.server.IncludeKpi(request)
        LOGGER.info('IncludeKpi result: {}'.format(response))
        return response

    def QueryKpiData(self, request):
        LOGGER.info('QueryKpiData: {}'.format(request))
        response = self.server.QueryKpiData(request)
        LOGGER.info('QueryKpiData result: {}'.format(response))
        return response

    def SubscribeKpi(self, request):
        LOGGER.info('SubscribeKpi: {}'.format(request))
        response = self.server.SubscribeKpi(request)
        LOGGER.info('SubscribeKpi result: {}'.format(response))
        return response

    def GetSubsDescriptor(self, request):
        LOGGER.info('GetSubsDescriptor: {}'.format(request))
        response = self.server.GetSubsDescriptor(request)
        LOGGER.info('GetSubsDescriptor result: {}'.format(response))
        return response

    def EditKpiSubscription(self, request):
        LOGGER.info('EditKpiSubscription: {}'.format(request))
        response = self.server.EditKpiSubscription(request)
        LOGGER.info('EditKpiSubscription result: {}'.format(response))
        return response

    def CreateKpiAlarm(self, request):
        LOGGER.info('CreateKpiAlarm: {}'.format(request))
        response = self.server.CreateKpiAlarm(request)
        LOGGER.info('CreateKpiAlarm result: {}'.format(response))
        return response

    def EditKpiAlarm(self, request):
        LOGGER.info('EditKpiAlarm: {}'.format(request))
        response = self.server.EditKpiAlarm(request)
        LOGGER.info('EditKpiAlarm result: {}'.format(response))
        return response

    def GetAlarms(self, request):
        LOGGER.info('GetAlarms: {}'.format(request))
        response = self.server.GetAlarms(request)
        LOGGER.info('GetAlarms result: {}'.format(response))
        return response

    def GetAlarmDescriptor(self, request):
        LOGGER.info('GetAlarmDescriptor: {}'.format(request))
        response = self.server.GetAlarmDescriptor(request)
        LOGGER.info('GetAlarmDescriptor result: {}'.format(response))
        return response


    # def GetStreamKpi(self, request):
    #     LOGGER.info('GetStreamKpi: {}'.format(request))
    #     response = self.server.GetStreamKpi(request)
    #     LOGGER.info('GetStreamKpi result: {}'.format(response))
    #     yield monitoring_pb2.Kpi()
    #
    # def GetInstantKpi(self, request):
    #     LOGGER.info('GetInstantKpi: {}'.format(request))
    #     response = self.server.GetInstantKpi(request)
    #     LOGGER.info('GetInstantKpi result: {}'.format(response))
    #     return monitoring_pb2.Kpi()



if __name__ == '__main__':
    # get port
    port = sys.argv[1] if len(sys.argv) > 1 else '7070'

    # make call to server
    client = MonitoringClient(port=port)
