# Copyright 2022-2024 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging, queue, socketio

LOGGER = logging.getLogger(__name__)

class RecommendationsClientNamespace(socketio.ClientNamespace):
    def __init__(self, request_queue : queue.Queue, reply_queue : queue.Queue):
        self._request_queue = request_queue
        self._reply_queue   = reply_queue
        super().__init__(namespace='/recommendations')

    def on_connect(self):
        LOGGER.info('[on_connect] Connected')

    def on_disconnect(self, reason):
        MSG = '[on_disconnect] Disconnected!, reason: {:s}'
        LOGGER.info(MSG.format(str(reason)))

    def on_recommendation(self, data):
        MSG = '[on_recommendation] data={:s}'
        LOGGER.info(MSG.format(str(data)))

        #MSG = '[on_recommendation] Recommendation: {:s}'
        #LOGGER.info(MSG.format(str(recommendation)))

        #request = (self._device_uuid, *sample)
        #self._request_queue.put_nowait(request)
