/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.hector.SkeletonConfiguration;
import net.sourceforge.plantuml.hector.SkeletonConfigurationComparator;
import net.sourceforge.plantuml.hector.SkeletonConfigurationEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkeletonConfigurationSet
implements Iterable<SkeletonConfiguration> {
    private final List<SkeletonConfiguration> all;
    private final SkeletonConfigurationComparator comparator;
    private final int limitSize;

    public SkeletonConfigurationSet(int n, SkeletonConfigurationEvaluator skeletonConfigurationEvaluator) {
        this.comparator = new SkeletonConfigurationComparator(skeletonConfigurationEvaluator);
        this.all = new ArrayList<SkeletonConfiguration>();
        this.limitSize = n;
    }

    public void add(SkeletonConfiguration skeletonConfiguration) {
        this.all.add(skeletonConfiguration);
        this.sortAndTruncate();
    }

    public void addAll(Collection<SkeletonConfiguration> collection) {
        this.all.addAll(collection);
        this.sortAndTruncate();
    }

    private void sortAndTruncate() {
        Collections.sort(this.all, this.comparator);
        while (this.all.size() > this.limitSize) {
            this.all.remove(this.all.size() - 1);
        }
    }

    public String toString() {
        return this.all.toString();
    }

    public int size() {
        return this.all.size();
    }

    @Override
    public Iterator<SkeletonConfiguration> iterator() {
        return new ArrayList<SkeletonConfiguration>(this.all).iterator();
    }

    public SkeletonConfiguration first() {
        return this.all.get(0);
    }
}

