import logging
from .WimconnectorIETFL2VPN import WimconnectorIETFL2VPN

LOGGER = logging.getLogger(__name__)

WIM_USERNAME = 'admin'
WIM_PASSWORD = 'admin'
WIM_MAPPING  = []

SERVICE_TYPE = 'ELAN'

class MockOSM:
    def __init__(self, wim_url):
        wim = {'wim_url': wim_url}
        wim_account = {'user': WIM_USERNAME, 'password': WIM_PASSWORD}
        config = {'service_endpoint_mapping': WIM_MAPPING}
        self.wim = WimconnectorIETFL2VPN(wim, wim_account, config=config)
        self.service_uuid = None

    def create_connectivity_service(self):
        connection_points = []
        self.wim.check_credentials()
        LOGGER.info('[create_connectivity_service] connection_points={:s}'.format(str(connection_points)))
        result = self.wim.create_connectivity_service(SERVICE_TYPE, connection_points)
        LOGGER.info('[create_connectivity_service] result={:s}'.format(str(result)))
        self.service_uuid = None

    def get_connectivity_service_status(self):
        connection_points = []
        self.wim.check_credentials()
        LOGGER.info('[get_connectivity_service] connection_points={:s}'.format(str(connection_points)))
        result = self.wim.get_connectivity_service_status(self.service_uuid, conn_info=conn_info)
        LOGGER.info('[get_connectivity_service] result={:s}'.format(str(result)))

    def edit_connectivity_service(self):
        connection_points = []
        self.wim.check_credentials()
        LOGGER.info('[edit_connectivity_service] connection_points={:s}'.format(str(connection_points)))
        result = self.wim.edit_connectivity_service(self.service_uuid, conn_info=conn_info, connection_points=connection_points)
        LOGGER.info('[edit_connectivity_service] result={:s}'.format(str(result)))

    def delete_connectivity_service(self):
        connection_points = []
        self.wim.check_credentials()
        LOGGER.info('[delete_connectivity_service] connection_points={:s}'.format(str(connection_points)))
        result = self.wim.delete_connectivity_service(self.service_uuid, conn_info=conn_info)
        LOGGER.info('[delete_connectivity_service] result={:s}'.format(str(result)))
