import grpc, json, logging
from google.protobuf.json_format import MessageToDict
from service.proto.context_pb2 import ConnectionList, Empty, Service, ServiceId
from service.proto.service_pb2_grpc import ServiceServiceServicer

LOGGER = logging.getLogger(__name__)

def grpc_message_to_json_string(message):
    return json.dumps(MessageToDict(
        message, including_default_value_fields=True, preserving_proto_field_name=True, use_integers_for_enums=False),
        sort_keys=True)

class MockServiceServiceServicerImpl(ServiceServiceServicer):
    def CreateService(self, request : Service, context : grpc.ServicerContext) -> ServiceId:
        LOGGER.info('[CreateService] request={:s}'.format(grpc_message_to_json_string(request)))
        return request.service_id

    def UpdateService(self, request : Service, context : grpc.ServicerContext) -> ServiceId:
        LOGGER.info('[UpdateService] request={:s}'.format(grpc_message_to_json_string(request)))
        return request.service_id

    def DeleteService(self, request : ServiceId, context : grpc.ServicerContext) -> Empty:
        LOGGER.info('[DeleteService] request={:s}'.format(grpc_message_to_json_string(request)))
        return Empty()

    def GetConnectionList(self, request : ServiceId, context : grpc.ServicerContext) -> ConnectionList:
        LOGGER.info('[GetConnectionList] request={:s}'.format(grpc_message_to_json_string(request)))
        return ConnectionList()
