/*
* Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package eu.teraflow.policy.monitoring.model;

public class AlarmResponse {

    private final String alarmId;
    private final String text;
    private final KpiValue<?> kpiValue;

    public AlarmResponse(String alarmId, String text, KpiValue<?> kpiValue) {
        this.alarmId = alarmId;
        this.text = text;
        this.kpiValue = kpiValue;
    }

    public String getAlarmId() {
        return alarmId;
    }

    public String getText() {
        return text;
    }

    public KpiValue getKpiValue() {
        return kpiValue;
    }

    @Override
    public String toString() {
        return String.format(
                "%s:{alarmId:\"%s\", text:\"%s\", %s}",
                getClass().getSimpleName(), alarmId, text, kpiValue);
    }
}
