/*
* Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package eu.teraflow.policy.model;

import eu.teraflow.policy.context.model.ServiceId;
import java.util.List;
import java.util.stream.Collectors;

public class PolicyRule {

    private final String policyRuleId;
    private final PolicyRuleType policyRuleType;
    private final int priority;
    private final PolicyRuleEvent event;
    private final List<PolicyRuleCondition> policyRuleConditions;
    private final BooleanOperator booleanOperator;
    private final List<PolicyRuleAction> policyRuleActions;
    private final ServiceId serviceId;
    private final List<String> deviceIds;

    public PolicyRule(
            String policyRuleId,
            PolicyRuleType policyRuleType,
            int priority,
            PolicyRuleEvent event,
            List<PolicyRuleCondition> policyRuleConditions,
            BooleanOperator booleanOperator,
            List<PolicyRuleAction> policyRuleActions,
            ServiceId serviceId,
            List<String> deviceIds) {
        this.policyRuleId = policyRuleId;
        this.policyRuleType = policyRuleType;
        this.priority = priority;
        this.event = event;
        this.policyRuleConditions = policyRuleConditions;
        this.booleanOperator = booleanOperator;
        this.policyRuleActions = policyRuleActions;
        this.serviceId = serviceId;
        this.deviceIds = deviceIds;
    }

    public String getPolicyRuleId() {
        return policyRuleId;
    }

    public PolicyRuleType getPolicyRuleType() {
        return policyRuleType;
    }

    public int getPriority() {
        return priority;
    }

    public PolicyRuleEvent getEvent() {
        return event;
    }

    public List<PolicyRuleCondition> getPolicyRuleConditions() {
        return policyRuleConditions;
    }

    public BooleanOperator getBooleanOperator() {
        return booleanOperator;
    }

    public List<PolicyRuleAction> getPolicyRuleActions() {
        return policyRuleActions;
    }

    public ServiceId getServiceId() {
        return serviceId;
    }

    public List<String> getDeviceIds() {
        return deviceIds;
    }

    @Override
    public String toString() {
        return String.format(
                "%s:{policyRuleId:\"%s\", policyRuleType:\"%s\", priority:%d, %s, [%s], booleanOperator:\"%s\", [%s], %s, [%s]}",
                getClass().getSimpleName(),
                policyRuleId,
                policyRuleType.toString(),
                priority,
                event,
                toString(policyRuleConditions),
                booleanOperator.toString(),
                toString(policyRuleActions),
                serviceId,
                toString(deviceIds));
    }

    private <T> String toString(List<T> list) {
        return list.stream().map(T::toString).collect(Collectors.joining(", "));
    }
}
