# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import te_node_attributes
class node_template(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/te/templates/node-template. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The list of TE node templates used to define sharable
and reusable TE node attributes.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__priority','__reference_change_policy','__te_node_attributes',)

  _yang_name = 'node-template'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '/?([a-zA-Z0-9\\-_.]+)(/[a-zA-Z0-9\\-_.]+)*'}), is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-template-name', is_config=True)
    self.__priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint16', is_config=True)
    self.__reference_change_policy = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'no-action': {}, 'not-allowed': {}, 'cascade': {}},), is_leaf=True, yang_name="reference-change-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='enumeration', is_config=True)
    self.__te_node_attributes = YANGDynClass(base=te_node_attributes.te_node_attributes, is_container='container', yang_name="te-node-attributes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'te', 'templates', 'node-template']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /networks/te/templates/node_template/name (te-types:te-template-name)

    YANG Description: The name to identify a TE node template.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /networks/te/templates/node_template/name (te-types:te-template-name)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name to identify a TE node template.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '/?([a-zA-Z0-9\\-_.]+)(/[a-zA-Z0-9\\-_.]+)*'}), is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-template-name', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with te-types:te-template-name""",
          'defined-type': "te-types:te-template-name",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '/?([a-zA-Z0-9\\-_.]+)(/[a-zA-Z0-9\\-_.]+)*'}), is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-template-name', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '/?([a-zA-Z0-9\\-_.]+)(/[a-zA-Z0-9\\-_.]+)*'}), is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-template-name', is_config=True)


  def _get_priority(self):
    """
    Getter method for priority, mapped from YANG variable /networks/te/templates/node_template/priority (uint16)

    YANG Description: The preference value for resolving conflicts between
different templates.  When two or more templates specify
values for one configuration attribute, the value from the
template with the highest priority is used.
A lower number indicates a higher priority.  The highest
priority is 0.
    """
    return self.__priority
      
  def _set_priority(self, v, load=False):
    """
    Setter method for priority, mapped from YANG variable /networks/te/templates/node_template/priority (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_priority() directly.

    YANG Description: The preference value for resolving conflicts between
different templates.  When two or more templates specify
values for one configuration attribute, the value from the
template with the highest priority is used.
A lower number indicates a higher priority.  The highest
priority is 0.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """priority must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint16', is_config=True)""",
        })

    self.__priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_priority(self):
    self.__priority = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint16', is_config=True)


  def _get_reference_change_policy(self):
    """
    Getter method for reference_change_policy, mapped from YANG variable /networks/te/templates/node_template/reference_change_policy (enumeration)

    YANG Description: This attribute specifies the action taken for a
configuration node that has a reference to this template.
    """
    return self.__reference_change_policy
      
  def _set_reference_change_policy(self, v, load=False):
    """
    Setter method for reference_change_policy, mapped from YANG variable /networks/te/templates/node_template/reference_change_policy (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_reference_change_policy is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_reference_change_policy() directly.

    YANG Description: This attribute specifies the action taken for a
configuration node that has a reference to this template.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'no-action': {}, 'not-allowed': {}, 'cascade': {}},), is_leaf=True, yang_name="reference-change-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """reference_change_policy must be of a type compatible with enumeration""",
          'defined-type': "ietf-te-topology:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'no-action': {}, 'not-allowed': {}, 'cascade': {}},), is_leaf=True, yang_name="reference-change-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='enumeration', is_config=True)""",
        })

    self.__reference_change_policy = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_reference_change_policy(self):
    self.__reference_change_policy = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'no-action': {}, 'not-allowed': {}, 'cascade': {}},), is_leaf=True, yang_name="reference-change-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='enumeration', is_config=True)


  def _get_te_node_attributes(self):
    """
    Getter method for te_node_attributes, mapped from YANG variable /networks/te/templates/node_template/te_node_attributes (container)

    YANG Description: Contains node attributes in a TE topology.
    """
    return self.__te_node_attributes
      
  def _set_te_node_attributes(self, v, load=False):
    """
    Setter method for te_node_attributes, mapped from YANG variable /networks/te/templates/node_template/te_node_attributes (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te_node_attributes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te_node_attributes() directly.

    YANG Description: Contains node attributes in a TE topology.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=te_node_attributes.te_node_attributes, is_container='container', yang_name="te-node-attributes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te_node_attributes must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=te_node_attributes.te_node_attributes, is_container='container', yang_name="te-node-attributes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__te_node_attributes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te_node_attributes(self):
    self.__te_node_attributes = YANGDynClass(base=te_node_attributes.te_node_attributes, is_container='container', yang_name="te-node-attributes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  priority = __builtin__.property(_get_priority, _set_priority)
  reference_change_policy = __builtin__.property(_get_reference_change_policy, _set_reference_change_policy)
  te_node_attributes = __builtin__.property(_get_te_node_attributes, _set_te_node_attributes)


  _pyangbind_elements = OrderedDict([('name', name), ('priority', priority), ('reference_change_policy', reference_change_policy), ('te_node_attributes', te_node_attributes), ])


