import grpc, logging
from common.tools.client.RetryDecorator import retry, delay_exponential
from centralizedcybersecurity.proto.context_pb2 import Empty
from centralizedcybersecurity.proto.service_pb2 import Service
from centralizedcybersecurity.proto.monitoring_pb2 import KpiList
from centralizedcybersecurity.proto.centralized_cybersecurity_pb2_grpc import CentralizedCyberSecurityServiceStub

LOGGER = logging.getLogger(__name__)
MAX_RETRIES = 15
DELAY_FUNCTION = delay_exponential(initial=0.01, increment=2.0, maximum=5.0)

class CentralizedCybersecurityClient:
    def __init__(self, address, port):
        self.endpoint = '{}:{}'.format(address, port)
        LOGGER.debug('Creating channel to {}...'.format(self.endpoint))
        self.channel = None
        self.stub = None
        self.connect()
        LOGGER.debug('Channel created')

    def connect(self):
        self.channel = grpc.insecure_channel(self.endpoint)
        self.stub = CentralizedCyberSecurityServiceStub(self.channel)

    def close(self):
        if(self.channel is not None): self.channel.close()
        self.channel = None
        self.stub = None

    @retry(exceptions=set(), max_retries=MAX_RETRIES, delay_function=DELAY_FUNCTION, prepare_method_name='connect')
    def NotifyServiceUpdate(self, request : Service) -> Empty:
        LOGGER.debug('NotifyServiceUpdate request: {}'.format(request))
        response = self.stub.NotifyServiceUpdate(request)
        LOGGER.debug('NotifyServiceUpdate result: {}'.format(response))
        return response

    @retry(exceptions=set(), max_retries=MAX_RETRIES, delay_function=DELAY_FUNCTION, prepare_method_name='connect')
    def DetectAttack(self, request : Empty) -> Empty:
        LOGGER.debug('DetectAttack request: {}'.format(request))
        response = self.stub.DetectAttack(request)
        LOGGER.debug('DetectAttack result: {}'.format(response))
        return response

    @retry(exceptions=set(), max_retries=MAX_RETRIES, delay_function=DELAY_FUNCTION, prepare_method_name='connect')
    def ReportSummarizedKpi(self, request : KpiList) -> Empty:
        LOGGER.debug('ReportSummarizedKpi request: {}'.format(request))
        response = self.stub.ReportSummarizedKpi(request)
        LOGGER.debug('ReportSummarizedKpi result: {}'.format(response))
        return response

    @retry(exceptions=set(), max_retries=MAX_RETRIES, delay_function=DELAY_FUNCTION, prepare_method_name='connect')
    def ReportKpi(self, request : KpiList) -> Empty:
        LOGGER.debug('ReportKpi request: {}'.format(request))
        response = self.stub.ReportKpi(request)
        LOGGER.debug('ReportKpi result: {}'.format(response))
        return response
