package eu.teraflow.policy.model;

public class PolicyRuleActionConfig {

    private final String actionKey;
    private final String actionValue;

    public PolicyRuleActionConfig(String actionKey, String actionValue) {
        this.actionKey = actionKey;
        this.actionValue = actionValue;
    }

    public String getActionKey() {
        return actionKey;
    }

    public String getActionValue() {
        return actionValue;
    }

    @Override
    public String toString() {
        return String.format(
                "%s:{resourceKey:\"%s\", resourceValue:\"%s\"}",
                getClass().getSimpleName(), actionKey, actionValue);
    }
}
