/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.image.BufferedImage;
import java.util.List;
import net.sourceforge.plantuml.ugraphic.SpriteGrayLevel;

public class SpriteUtils {
    private SpriteUtils() {
    }

    public static String encode(BufferedImage bufferedImage, String string, SpriteGrayLevel spriteGrayLevel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("sprite $" + string + " [" + bufferedImage.getWidth() + "x" + bufferedImage.getHeight() + "/" + spriteGrayLevel.getNbColor() + "] {\n");
        List<String> list = spriteGrayLevel.encode(bufferedImage);
        for (String string2 : list) {
            stringBuilder.append(string2);
            stringBuilder.append("\n");
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    public static String encodeCompressed(BufferedImage bufferedImage, String string, SpriteGrayLevel spriteGrayLevel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("sprite $" + string + " [" + bufferedImage.getWidth() + "x" + bufferedImage.getHeight() + "/" + spriteGrayLevel.getNbColor() + "z] ");
        List<String> list = spriteGrayLevel.encodeZ(bufferedImage);
        if (list.size() == 1) {
            stringBuilder.append(list.get(0));
            stringBuilder.append("\n");
        } else {
            stringBuilder.append("{\n");
            for (String string2 : list) {
                stringBuilder.append(string2);
                stringBuilder.append("\n");
            }
            stringBuilder.append("}\n");
        }
        return stringBuilder.toString();
    }
}

