-module(epce_sup).

-behaviour(supervisor).


%%% EXPORTS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Behaviour supervisor functions
-export([start_link/0]).
-export([init/1]).


%%% MACROS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

-define(TED_WORKER, epce_ted).
-define(PCE_WORKER, epce_server).


%%% BEHAVIOUR SUPERVISOR FUNCTIONS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

start_link() ->
    supervisor:start_link({local, ?MODULE}, ?MODULE, []).

init([]) ->
    SupFlags = #{
        strategy => one_for_all,
        intensity => 0,
        period => 1
    },
    TEDSpec = #{
        id => ?TED_WORKER,
        start => {?TED_WORKER, start_link, []},
        restart => permanent,
        shutdown => brutal_kill
    },
    ServerSpec = #{
        id => ?PCE_WORKER,
        start => {?PCE_WORKER, start_link, []},
        restart => permanent,
        shutdown => brutal_kill
    },
    {ok, {SupFlags, [TEDSpec, ServerSpec]}}.

