import grpc, os
import logging
from concurrent import futures
from grpc_health.v1.health import HealthServicer, OVERALL_HEALTH
from grpc_health.v1.health_pb2 import HealthCheckResponse
from grpc_health.v1.health_pb2_grpc import add_HealthServicer_to_server
from context.proto.context_pb2_grpc import add_ContextServiceServicer_to_server
from context.service.ContextServiceServicerImpl import ContextServiceServicerImpl
from context.Config import SERVICE_PORT, MAX_WORKERS, GRACE_PERIOD

BIND_ADDRESS = '0.0.0.0'
LOGGER = logging.getLogger(__name__)

class ContextService:
    def __init__(self, database, address=BIND_ADDRESS, port=SERVICE_PORT, max_workers=MAX_WORKERS,
                 grace_period=GRACE_PERIOD):
        self.database = database
        self.address = address
        self.port = port
        self.endpoint = None
        self.max_workers = max_workers
        self.grace_period = grace_period
        self.context_servicer = None
        self.health_servicer = None
        self.pool = None
        self.server = None

    def start(self):
        self.endpoint = '{}:{}'.format(self.address, self.port)
        LOGGER.debug('Starting Service (tentative endpoint: {}, max_workers: {})...'.format(
            self.endpoint, self.max_workers))

        self.pool = futures.ThreadPoolExecutor(max_workers=self.max_workers)
        self.server = grpc.server(self.pool) # , interceptors=(tracer_interceptor,))

        self.context_servicer = ContextServiceServicerImpl(self.database)
        add_ContextServiceServicer_to_server(self.context_servicer, self.server)

        self.health_servicer = HealthServicer(
            experimental_non_blocking=True, experimental_thread_pool=futures.ThreadPoolExecutor(max_workers=1))
        add_HealthServicer_to_server(self.health_servicer, self.server)

        port = self.server.add_insecure_port(self.endpoint)
        self.endpoint = '{}:{}'.format(self.address, port)
        LOGGER.info('Listening on {}...'.format(self.endpoint))
        self.server.start()
        self.health_servicer.set(OVERALL_HEALTH, HealthCheckResponse.SERVING) # pylint: disable=maybe-no-member

        LOGGER.debug('Service started')

    def stop(self):
        LOGGER.debug('Stopping service (grace period {} seconds)...'.format(self.grace_period))
        self.health_servicer.enter_graceful_shutdown()
        self.server.stop(self.grace_period)
        LOGGER.debug('Service stopped')
