import logging, os
from enum import Enum
from .inmemory.InMemoryDatabase import InMemoryDatabase
from .redis.RedisDatabase import RedisDatabase

LOGGER = logging.getLogger(__name__)

class DatabaseEngineEnum(Enum):
    INMEMORY = 'inmemory'
    REDIS = 'redis'
    #MONGO = 'mongo'
    #RETHINK = 'rethink'
    #ETCD = 'etcd'

ENGINES = {
    DatabaseEngineEnum.INMEMORY.value: InMemoryDatabase,
    DatabaseEngineEnum.REDIS.value: RedisDatabase,
    #DatabaseEngineEnum.MONGO.value: MongoDatabase,
    #DatabaseEngineEnum.RETHINK.value: RethinkDatabase,
    #DatabaseEngineEnum.ETCD.value: EtcdDatabase,
}

DEFAULT_DB_ENGINE = DatabaseEngineEnum.INMEMORY

def get_database(engine=None, **parameters):
    if engine is None: engine = os.environ.get('DB_ENGINE', DEFAULT_DB_ENGINE)
    if(isinstance(engine, DatabaseEngineEnum)): engine = engine.value
    LOGGER.info('Selected Database Engine: {}'.format(engine))
    engine_class = ENGINES.get(engine)
    if engine_class is None: raise Exception('Unsupported Engine({})'.format(engine))
    return engine_class(**parameters)
