/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverLineG2d
extends DriverShadowedG2d
implements UDriver<Graphics2D> {
    private final double dpiFactor;

    public DriverLineG2d(double d) {
        this.dpiFactor = d;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, Graphics2D graphics2D) {
        ULine uLine = (ULine)uShape;
        Line2D.Double double_ = new Line2D.Double(d, d2, d + uLine.getDX(), d2 + uLine.getDY());
        DriverLineG2d.manageStroke(uParam, graphics2D);
        if (uLine.getDeltaShadow() != 0.0) {
            this.drawShadow(graphics2D, double_, uLine.getDeltaShadow(), this.dpiFactor);
        }
        graphics2D.setColor(colorMapper.getMappedColor(uParam.getColor()));
        graphics2D.draw(double_);
    }

    static void manageStroke(UParam uParam, Graphics2D graphics2D) {
        UStroke uStroke = uParam.getStroke();
        float f = (float)(uStroke.getThickness() * uParam.getScale());
        if (uStroke.getDashVisible() == 0.0) {
            graphics2D.setStroke(new BasicStroke(f));
        } else {
            float f2 = (float)uStroke.getDashVisible();
            float f3 = (float)uStroke.getDashSpace();
            float[] fArray = new float[]{f2, f3};
            graphics2D.setStroke(new BasicStroke(f, 0, 0, 10.0f, fArray, 0.0f));
        }
    }
}

