const grpc = require('@grpc/grpc-js');
const protoLoader = require('@grpc/proto-loader');
const path = require('path');

const PROTO_PATH = path.resolve(__dirname, '../proto/dlt_service.proto');
const packageDefinition = protoLoader.loadSync(PROTO_PATH, {
  keepCase: true,
  longs: String,
  enums: String,
  defaults: true,
  oneofs: true,
});
const dltProto = grpc.loadPackageDefinition(packageDefinition).dlt;

const client = new dltProto.DltGatewayService(
  '10.1.1.96:32001',
  grpc.credentials.createInsecure()
);

function subscribeToDlt() {
  const request = {
    // Define any necessary subscription filters here if applicable
  };

  const call = client.SubscribeToDlt(request);

  call.on('data', (event) => {
    console.log('Received event:', event);
  });

  call.on('error', (error) => {
    console.error('Error:', error.message);
  });

  call.on('end', () => {
    console.log('Stream ended.');
  });

  // Optionally, you can cancel the subscription after a certain time or condition
  setTimeout(() => {
    console.log('Cancelling subscription...');
    call.cancel();
  }, 600000); // Cancel after 1 minute for demonstration purposes
}

function runTests() {
  console.log("Testing subscription to DLT events");
  subscribeToDlt();
}

runTests();
