import logging, pytest
from opticalcentralizedattackdetector.Config import GRPC_SERVICE_PORT, GRPC_MAX_WORKERS, GRPC_GRACE_PERIOD
from opticalcentralizedattackdetector.client.OpticalCentralizedAttackDetectorClient import OpticalCentralizedAttackDetectorClient
from opticalcentralizedattackdetector.proto.context_pb2 import Empty, Service
from opticalcentralizedattackdetector.proto.monitoring_pb2 import Kpi, KpiList
from opticalcentralizedattackdetector.service.OpticalCentralizedAttackDetectorService import OpticalCentralizedAttackDetectorService

port = 10000 + GRPC_SERVICE_PORT # avoid privileged ports

LOGGER = logging.getLogger(__name__)
LOGGER.setLevel(logging.DEBUG)

@pytest.fixture(scope='session')
def optical_centralized_attack_detector_service():
    _service = OpticalCentralizedAttackDetectorService(
        port=port, max_workers=GRPC_MAX_WORKERS, grace_period=GRPC_GRACE_PERIOD)
    _service.start()
    yield _service
    _service.stop()

@pytest.fixture(scope='session')
def optical_centralized_attack_detector_client(optical_centralized_attack_detector_service):
    _client = OpticalCentralizedAttackDetectorClient(address='127.0.0.1', port=port)
    yield _client
    _client.close()

def test_notify_service_update(optical_centralized_attack_detector_client: OpticalCentralizedAttackDetectorClient):
    service = Service()
    optical_centralized_attack_detector_client.NotifyServiceUpdate(service)

def test_detect_attack(optical_centralized_attack_detector_client: OpticalCentralizedAttackDetectorClient):
    request = Empty()
    optical_centralized_attack_detector_client.DetectAttack(request)

def test_report_summarized_kpi(optical_centralized_attack_detector_client: OpticalCentralizedAttackDetectorClient):
    kpi_list = KpiList()
    optical_centralized_attack_detector_client.ReportSummarizedKpi(kpi_list)

def test_report_kpi(optical_centralized_attack_detector_client: OpticalCentralizedAttackDetectorClient):
    kpi_list = KpiList()
    optical_centralized_attack_detector_client.ReportKpi(kpi_list)
