import grpc, logging
from common.rpc_method_wrapper.Decorator import create_metrics, safe_and_metered_rpc_method
from opticalcentralizedattackdetector.proto.context_pb2 import Empty, Service
from opticalcentralizedattackdetector.proto.monitoring_pb2 import KpiList
from opticalcentralizedattackdetector.proto.optical_centralized_attack_detector_pb2_grpc import (
    OpticalCentralizedAttackDetectorServiceServicer)

LOGGER = logging.getLogger(__name__)

SERVICE_NAME = 'OpticalCentralizedAttackDetector'
METHOD_NAMES = ['NotifyServiceUpdate', 'DetectAttack', 'ReportSummarizedKpi', 'ReportKpi']
METRICS = create_metrics(SERVICE_NAME, METHOD_NAMES)

class OpticalCentralizedAttackDetectorServiceServicerImpl(OpticalCentralizedAttackDetectorServiceServicer):

    def __init__(self):
        LOGGER.debug('Creating Servicer...')
        LOGGER.debug('Servicer Created')

    @safe_and_metered_rpc_method(METRICS, LOGGER)
    def NotifyServiceUpdate(self, request : Service, context : grpc.ServicerContext) -> Empty:
        return Empty()

    @safe_and_metered_rpc_method(METRICS, LOGGER)
    def DetectAttack(self, request : Empty, context : grpc.ServicerContext) -> Empty:
        return Empty()

    @safe_and_metered_rpc_method(METRICS, LOGGER)
    def ReportSummarizedKpi(self, request : KpiList, context : grpc.ServicerContext) -> Empty:
        return Empty()

    @safe_and_metered_rpc_method(METRICS, LOGGER)
    def ReportKpi(self, request : KpiList, context : grpc.ServicerContext) -> Empty:
        return Empty()
