# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_global_class import TapiCommonGlobalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_layer_protocol_name import TapiCommonLayerProtocolName  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server.models.tapi_topology_link import TapiTopologyLink  # noqa: F401,E501
from tapi_server.models.tapi_topology_node import TapiTopologyNode  # noqa: F401,E501
from tapi_server import util


class TapiTopologyTopology(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, name: List[TapiCommonNameAndValue]=None, uuid: str=None, layer_protocol_name: List[TapiCommonLayerProtocolName]=None, link: List[TapiTopologyLink]=None, node: List[TapiTopologyNode]=None):  # noqa: E501
        """TapiTopologyTopology - a model defined in Swagger

        :param name: The name of this TapiTopologyTopology.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param uuid: The uuid of this TapiTopologyTopology.  # noqa: E501
        :type uuid: str
        :param layer_protocol_name: The layer_protocol_name of this TapiTopologyTopology.  # noqa: E501
        :type layer_protocol_name: List[TapiCommonLayerProtocolName]
        :param link: The link of this TapiTopologyTopology.  # noqa: E501
        :type link: List[TapiTopologyLink]
        :param node: The node of this TapiTopologyTopology.  # noqa: E501
        :type node: List[TapiTopologyNode]
        """
        self.swagger_types = {
            'name': List[TapiCommonNameAndValue],
            'uuid': str,
            'layer_protocol_name': List[TapiCommonLayerProtocolName],
            'link': List[TapiTopologyLink],
            'node': List[TapiTopologyNode]
        }

        self.attribute_map = {
            'name': 'name',
            'uuid': 'uuid',
            'layer_protocol_name': 'layer-protocol-name',
            'link': 'link',
            'node': 'node'
        }
        self._name = name
        self._uuid = uuid
        self._layer_protocol_name = layer_protocol_name
        self._link = link
        self._node = node

    @classmethod
    def from_dict(cls, dikt) -> 'TapiTopologyTopology':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.topology.Topology of this TapiTopologyTopology.  # noqa: E501
        :rtype: TapiTopologyTopology
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiTopologyTopology.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiTopologyTopology.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiTopologyTopology.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiTopologyTopology.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def uuid(self) -> str:
        """Gets the uuid of this TapiTopologyTopology.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :return: The uuid of this TapiTopologyTopology.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid: str):
        """Sets the uuid of this TapiTopologyTopology.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :param uuid: The uuid of this TapiTopologyTopology.
        :type uuid: str
        """

        self._uuid = uuid

    @property
    def layer_protocol_name(self) -> List[TapiCommonLayerProtocolName]:
        """Gets the layer_protocol_name of this TapiTopologyTopology.

        none  # noqa: E501

        :return: The layer_protocol_name of this TapiTopologyTopology.
        :rtype: List[TapiCommonLayerProtocolName]
        """
        return self._layer_protocol_name

    @layer_protocol_name.setter
    def layer_protocol_name(self, layer_protocol_name: List[TapiCommonLayerProtocolName]):
        """Sets the layer_protocol_name of this TapiTopologyTopology.

        none  # noqa: E501

        :param layer_protocol_name: The layer_protocol_name of this TapiTopologyTopology.
        :type layer_protocol_name: List[TapiCommonLayerProtocolName]
        """

        self._layer_protocol_name = layer_protocol_name

    @property
    def link(self) -> List[TapiTopologyLink]:
        """Gets the link of this TapiTopologyTopology.

        none  # noqa: E501

        :return: The link of this TapiTopologyTopology.
        :rtype: List[TapiTopologyLink]
        """
        return self._link

    @link.setter
    def link(self, link: List[TapiTopologyLink]):
        """Sets the link of this TapiTopologyTopology.

        none  # noqa: E501

        :param link: The link of this TapiTopologyTopology.
        :type link: List[TapiTopologyLink]
        """

        self._link = link

    @property
    def node(self) -> List[TapiTopologyNode]:
        """Gets the node of this TapiTopologyTopology.

        none  # noqa: E501

        :return: The node of this TapiTopologyTopology.
        :rtype: List[TapiTopologyNode]
        """
        return self._node

    @node.setter
    def node(self, node: List[TapiTopologyNode]):
        """Sets the node of this TapiTopologyTopology.

        none  # noqa: E501

        :param node: The node of this TapiTopologyTopology.
        :type node: List[TapiTopologyNode]
        """

        self._node = node
